import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select, Button, Input } from 'amos-framework';
import BizIcon from './../../../../common/icon/BizIcon';

const Option = Select.Option;

/**
 * 工具栏
 *
 * @class FireEquipmentToolBar
 * @extends {Component}
 */
class FireEquipmentToolBar extends Component {
  constructor(props) {
    super(props);
    this.state = {
      name: '',
      equipClassify: -1,
      searchParam: []
    };
  }

  componentWillMount() {

  }

  onSelectChange(index, value) {
    let { searchParam } = this.state;
    let { getTableListData, pageConfig } = this.props;

    searchParam.equipClassify = value.value === -1 ? '0,1,3' : value.value;
    searchParam.pageNumber = pageConfig.pageNumber;
    searchParam.pageSize = pageConfig.pageSize;
    this.setState({
      searchParam,
      equipClassify: index
    }, () => getTableListData(searchParam));
  }

  onChange = (e, value) => {
    let { searchParam } = this.state;
    let { getTableListData, pageConfig } = this.props;
    this.setState({ name: value });
    searchParam.name = value;
    searchParam.pageNumber = pageConfig.pageNumber;
    searchParam.pageSize = pageConfig.pageSize;
    this.setState({
      searchParam
    }, () => getTableListData(searchParam));
  };

  render() {
    let { name } = this.state;
    return (
      <div className="fire-truck-toolbar">
        <div className="fire-truck-input">
          <span>分类：</span>
          <Select onChange={(e, value) => this.onSelectChange(e, value)} defaultValue={-1}>
            <Option value={-1}>全部</Option>
            <Option value={0}>设备类</Option>
            <Option value={1}>耗材类</Option>
            <Option value={3}>灭火器材</Option>
          </Select>
          <span>装备名称：</span>
          <Input value={name} onChange={e => this.onChange('name', e.target.value)} />
        </div>
        <div className="fire-truck-buttons">
          <Button icon={<BizIcon icon="tianjia" />} transparent onClick={this.props.add} />
          <Button icon={<BizIcon icon="xiugai" />} transparent onClick={this.props.edit} />
          <Button icon={<BizIcon icon="shanchu" />} transparent onClick={this.props.delete} />
        </div>
      </div>
    );
  }
}

FireEquipmentToolBar.propTypes = {
  add: PropTypes.func,
  edit: PropTypes.func,
  delete: PropTypes.func,
  getTableListData: PropTypes.func,
  pageConfig: PropTypes.object
};

export default FireEquipmentToolBar;
