import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { browserHistory } from 'amos-react-router';
import dt2react from 'dt2react';
import { fetchPointListAction } from './../../../services/checkInfoService';
import AmosGridTable from './../common/tableComponent/table/AmosGridTable';
import PointSearch from './PointSearch';
import { pathMapping } from './../../../routes/customRoutes';

const CheckListPath = pathMapping.pointCheckList;
const pointInfoPath = pathMapping.pointInfo;
const strUnique = str => {
  if(str){
    let arr = str.split(',')
    let newarr=[...new Set(arr)]
    return newarr.join(",")
  }else{
    return '';
  }
 }

const pointListColumns = (changeColour, self) => {
  return [
    {
      title: '编号',
      dataIndex: 'no',
      key: 'no',
      width: '7%'
    },
    {
      title: '名称',
      dataIndex: 'name',
      key: 'name',
      width: '10%'
    },
    {
      title: '级别',
      dataIndex: 'level',
      key: 'level',
      width: '4%'
    },
    {
      title: '类型',
      dataIndex: 'checkType',
      key: 'checkType',
      width: '10%'
    },
    {
      title: '部门',
      dataIndex: 'groupName',
      key: 'groupName',
      width: '10%'
      , render: text => (strUnique(text))
    },
    {
      title: '责任人',
      dataIndex: 'realName',
      key: 'realName',
      width: '19%'
    },
    /**

    {
      title: '联系方式',
      dataIndex: 'loginName',
      key: 'loginName',
      width: '10%'
    },
     */
    {
      title: '状态',
      dataIndex: 'realTimeStatus',
      key: 'realTimeStatus',
      width: '5%',
      render: text => (changeColour(text))
    },
    {
      title: '最新数据时间',
      dataIndex: 'checkTime',
      key: 'checkTime',
      width: '12%'
    },
    {
      title: '最新异常内容',
      dataIndex: 'errorMsg',
      key: 'errorMsg',
      width: '15%',
      render: text => <span style={{color:'#FF9900'}}>{text}</span>
    },
    {
      title: '操作',
      dataIndex: '',
      key: 'operation',
      width: '8%',
      render: function( text, record, index) {
        return <span><a href="javascript:;" onClick={function() { self.onDetailClick(record)} }>详情</a>&nbsp;&nbsp;&nbsp;<a href="javascript:;" onClick={function() { self.onRowClick(record)} }>巡检记录</a> </span>;
      }
    }
  ];
};
//偏移110px
const offsetHeight = 110;
const defaultHeight = 390;
/**
 *巡检点列表页面
 *
 * @class PointListView
 * @extends {Component}
 */
class PointListView extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: props.outterPageConfig ? props.outterPageConfig.current : 1,
      pageSize: props.outterPageConfig ? props.outterPageConfig.pageSize : 10
    };
    this.state = {
      searchParam: {},
      dataList: [],
      totalCount: 0,
      selectedRows: [],
      selectedRowKeys: [],
      reload() {},
      status:''
    };
  }

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  componentWillReceiveProps(nextProps){
    const { status } = nextProps || {};
    status && this.setState({status});
  }

  changeColour = text => {
    if (text === '合格') {
      text = <span style={{ color: '#339900' }}>合格</span>;
    } else if (text === '不合格') {
      text = <span style={{ color: '#FF9900' }}>不合格</span>;
    } else if (text === '漏检') {
      text = <span style={{ color: '#FF0000' }}>漏检</span>;
    }else if (text === '未纳入巡检计划') {
      text = <span style={{ color: '#04cede' }}>未纳入巡检计划</span>;
    }
    return text;
  };
  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  setSearchParam = searchParam => {
    this.setState({ searchParam,status:'' },() => this.getPointListData(searchParam));
  };

  getPointListData = param => {
    let { searchParam } = this.state;

    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    Object.assign(searchParam, { ...param });
    fetchPointListAction(searchParam).then(data => {
      this.setState({
        dataList: data.content,
        totalCount: data.totalElements
      });
    });
  };

  getRowClassName = (record, index) => {
    let highlight = this.highlight;
    if (highlight && record.id === highlight) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  };

  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.current = current;
    }
  };

  getPanelHeight = () => {
    return defaultHeight;
  };

  onRowClick = record => {
    let { pointID, name } = record;
    let path = {
      pathname: CheckListPath,
      state: { pointID: pointID, pointName: name }
    };
    browserHistory.push(path);
  };

  onDetailClick = record => {
    let path = {
      pathname: pointInfoPath,
      state: { pointDetail: record }
    };
    browserHistory.push(path);
  };

  render() {
    let { dataList, totalCount, status } = this.state;
    const changeColour = this.changeColour;
    return (
      <div className="create-device-root">
        <div className="create-device-host-top">
          <div className="table-title">风险点信息列表</div>
          <div className="table-search">
            <PointSearch setSearchParam={this.setSearchParam} countStatus={status} />
          </div>
        </div>
        <div className="create-device-host-bottom">
          <div className="device-list-content">
            <AmosGridTable
              rowKey="pointID"
              columns={pointListColumns(changeColour, this)}
              callBack={this.reload}
              dataList={dataList}
              totals={totalCount}
              getTableDataAction={this.getPointListData}
              getSelectedRows={this.getSelectedRows}
              rowClassName={this.getRowClassName}
              setPageConfig={this.setPageConfig}
              getPanelHeight={this.getPanelHeight}
              defaultPageConlHeight={this.getPanelHeight}
              isChecked={false}
            />
          </div>
        </div>
      </div>
    );
  }
}

PointListView.propTypes = {};

export default PointListView;
