import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select,Input } from 'amos-antd';
import { MultiSelect, Button } from 'amos-framework';
import {
  fetchPointQueryCriteria,
  queryUserByDeptIdAction
} from './../../../services/checkInfoService';
import BizIcon from '../../common/icon/BizIcon';

const Option = Select.Option;
const multiSelectOption = MultiSelect.Option;
/**
 *
 *
 * @class XJCheckSearch
 * @extends {Component}
 */
class PointSearch extends Component {
  constructor(props){
    super(props);
    this.state = {
      userData: [],
      dataTypeOptions: [],
      departmentOptions: [],
      statusData: [],
      searchParam: {},
      selectData:[]
    };
  }
  componentWillMount() {

  }

  componentDidMount(){
    this.getPointSearchConditionAction();
  }

  componentWillReceiveProps(nextProps) {
    const { countStatus } =  nextProps || {};
    let status = [];
    let { searchParam, selectData, statusData } =  this.state;
    if (countStatus){
      let temp = statusData.find(item => item.value === countStatus);
      console.log('temp--------------->' + temp);
      if (temp !== undefined) {
        searchParam.checkStatus = temp.value;
        let checkStatus = [];
        checkStatus.push(temp.value);
        Object.assign(searchParam,{ pageNumber: 0,pageSize: 10 });
        this.setState({ searchParam,selectData: checkStatus },()=>this.props.setSearchParam(searchParam));
      }
    }
  }

  componentWillUnmount() {

  }

  onChange = (e) => {
    let { searchParam } = this.state;
    searchParam['name'] = e.target.value;
    this.setState({ searchParam });
  }

  onSelectedChange = (value,type) => {
    let { searchParam,selectData } = this.state;
    searchParam[type] = value;
    let selectStatus = [];
    if(type === 'checkStatus'){
      searchParam[type] = value.join(',');
      selectStatus = value;
    }

    Object.assign(searchParam,{ pageNumber: 0,pageSize: 10 });
    this.setState({ searchParam,selectData: selectStatus });
    searchParam && this.props.setSearchParam(searchParam);
  }

  onDeptChange = (value) => {
    this.queryUserByDept(value);
  }

  queryUserByDept = deptId => {
    queryUserByDeptIdAction(deptId).then(data => {
      let userData = data;
      this.setState({ userData: userData });
    });
  };


  //查询巡检人员
  getPointSearchConditionAction =()=>{
    fetchPointQueryCriteria().then(data=>{
      let userlist = [];
      let departmentList = [];
      let typeList = [];
      let statusList = [];
      let pointLevelList = [];

      data.departments ? data.departments.map(e => {
        if (e) {
          departmentList.push(<Option value={`${e.id}`}>{e.departmentName}</Option>);
        }
      }) : [];

      data.types ? data.types.map(e=>{
        if (e) {
          typeList.push(
            <Option value={`${e.id}`}>{e.name}</Option>);
        }
      }) : [];

      data.pointLevel ? data.pointLevel.map(e=>{
        if (e) {
          pointLevelList.push(
            <Option value={`${e.value}`}>{e.name}</Option>);
        }
      }) : [];

      this.setState({ dataTypeOptions: typeList,
        departmentOptions: departmentList, statusOptions: statusList, pointLevelOptions: pointLevelList, statusData: data.status });
    });
  }

  searchData = () => {
    let { searchParam } = this.state;
    Object.assign(searchParam, { pageNumber: 0,pageSize: 10 });
    searchParam && this.props.setSearchParam(searchParam);
  }

  render() {
    let { userData, dataTypeOptions, departmentOptions, statusData, pointLevelOptions ,selectData } = this.state;
    const checkUserOptions = userData.map(d => <Option key={d.id}>{d.label}</Option>);
    return (
      <div className='create-device-search-root'>
        <div className='catalog-select'>
          <Select
            style={{ width: '150px' }}
            dropdownStyle={{ width: '150px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'pointLevel')}
            placeholder='巡检点级别'
            allowClear
          >
            {pointLevelOptions}
          </Select>
        </div>
        <div className='catalog-select'>
          <Select
            style={{ width: '150px' }}
            dropdownStyle={{ width: '150px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'checkType')}
            placeholder='类型'
            allowClear
          >
            {dataTypeOptions}
          </Select>
        </div>
        <div className='catalog-select'>
          <Select
            style={{ width: '150px' }}
            dropdownStyle={{ width: '150px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onDeptChange(e)}
            placeholder='部门'
            allowClear
          >
            {departmentOptions}
          </Select>
        </div>

        <div className='catalog-select'>
          <Select
            style={{ width: '150px' }}
            dropdownStyle={{ width: '150px' }}
            dropdownMatchSelectWidth
            onChange={(e)=>this.onSelectedChange(e,'userId')}
            placeholder='巡检人员'
            allowClear
          >
          {checkUserOptions}
          </Select>
        </div>
        <div className='catalog-select-multiple'>
          <MultiSelect
            data = {statusData}
            renderOption={item => <multiSelectOption value={item.value}>{item.name}</multiSelectOption>}
            values={selectData}
            onChange={(e)=>this.onSelectedChange(e,'checkStatus')}
            placeholder='巡检状态'
          />
        </div>
        <div className='search-device'>
          <Input placeholder="请输入搜索内容" onChange={this.onChange} onPressEnter={this.searchData} style={{ width: '150px','border-radius': '10px' }} />
          <img src={require('./../../../assets/fsc/check/search.png')} alt='' onClick={this.searchData} />
          {/*<Button icon={<BizIcon icon='sousuo' />} transparent onClick={this.searchData} />*/}
        </div>
      </div>
    );
  }
}

PointSearch.propTypes = {
  setSearchParam: PropTypes.func
};

export default PointSearch;
