import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import BarOptions from 'amos-viz/lib/echarts/options/bar';
import { fetchPointStatistics } from './../../../services/checkInfoService';

/**
 * 巡检点统计
 * @class PointStatistics
 * @extends {Component}
 */
class PointStatistics extends Component {
  constructor(props) {
    super(props);
    this.state = {
      dataList: []
    };
  }

  componentDidMount() {
    this.getOptionsStatistics();
  }

  getOptionsStatistics() {
    fetchPointStatistics().then(data => {
      this.setState({
        dataList: data
      });
    });
  }
  getOptions(dataList, total) {
    return {
      color: ['#FF0000', '#04cede', '#66cc00', '#ffcc00'],
      series: [
        {
          name: '巡检点统计',
          // silent: true,
          type: 'pie',
          radius: ['45%', '65%'],
          itemStyle: {
            normal: {
              label: {
                show: true,
                position: 'center',
                formatter: function(params) {
                  let dataIndex = params.dataIndex;
                  if (parseInt(dataIndex) === 0) {
                    return '{a|' + total + '}' + '\r\n' + '{b|' + '总数' + '}';
                  } else {
                    return '';
                  }
                },
                rich: {
                  a: {
                    fontSize: '28',
                    color: 'black'
                  },
                  b: {
                    fontSize: '16',
                    color: 'black'
                  }
                }
              },
              labelLine: {
                show: false
              }
            },
            emphasis: {
              labelLine: {
                show: true,
                length:90
              },
              label: {
                show: true,
                position: 'outer',
                formatter: '{b}\n {c}({d}%)',
                textStyle: {
                  fontSize: '25',
                  fontWeight: 'bold'
                }
              }
            }
          },
          data: dataList
        }
      ]
    };
  }
onClick =(e)=>{
  e.data && this.props.onClick(e.data.status);
}

render(){
    const data = this.state.dataList;
    let error = 0;
    let total = 0;
    data &&
      data.map(e => {
        total += e.value;
        if (e.name === '漏检' || e.name === '不合格') {
          error = error + e.value;
        }
      });
    const option = this.getOptions(data, total);
    return (
      <div className="point-statistics">
        <div className="point-statistics-title">巡检点统计</div>
        <AmosEcharts option={option} eventpool={{ 'click': e=>this.onClick(e) }} />
        <div className="point-statistics-concent">
          异常点数：<span>{error}</span>
        </div>
      </div>
    );
  }
}

PointStatistics.propTypes = {};

PointStatistics.defaultProps = {
  data: {},
  legend: [],
  chartStyle: { width: '100%', height: '20rem' }
};

export default PointStatistics;
