import React, { Component } from 'react';
import PointListView from './PointListView';
import PointStatistics from './PointStatistics';
import MonthlyInspection from './MonthlyInspection';
import ExecutionSituation from './ExecutionSituation';

/**
 * 业务视图
 *
 * @class PointView
 * @extends {Component}
 */

class PointView extends Component {
   constructor(props){
     super(props);
     this.state = {
       searchStatus:[]
     }
   }

  onChangeStatus= (e) =>{
    this.setState({searchStatus: e});
  }

  render() {
    let { searchStatus } = this.state;
    return (
      <div className="point-view">
        <div className="point-first-row">
          <PointStatistics onClick = {this.onChangeStatus}/>
          <MonthlyInspection />
          <ExecutionSituation />
        </div>
        <PointListView status = {searchStatus}/> 
        {/* <PointListView /> */}
      </div>
    );
  }
}

PointView.propTypes = {};

export default PointView;
