import moment from 'moment';

/**
 * 设备设施危险因素清单
 */
const equipRiskFactorListHeader = [
  {
    title: '危险因素名称',
    dataIndex: 'name',
    key: 'name',
    width: '5%'
  },
  {
    title: '风险等级',
    dataIndex: 'riskFactorLevelName',
    key: 'riskFactorLevelName',
    width: '5%'
  },
  {
    title: '危险源名称',
    dataIndex: 'riskSourceName',
    key: 'riskSourceName',
    width: '5%'
  },
  {
    title: '设备位号',
    dataIndex: 'equipmentCode',
    key: 'equipmentCode',
    width: '5%'
  },
  {
    title: '设备名称',
    dataIndex: 'controlObjectName',
    key: 'controlObjectName',
    width: '5%'
  },
  {
    title: '所属工段',
    dataIndex: 'workshopSection',
    key: 'workshopSection',
    width: '5%'
  },
  {
    title: '部门/车间',
    dataIndex: 'equipmentDepartmentName',
    key: 'equipmentDepartmentName',
    width: '5%'
  },
  {
    title: '所在分区',
    dataIndex: 'regionName',
    key: 'regionName',
    width: '5%'
  },
  {
    title: '辨识人',
    dataIndex: 'userNames',
    key: 'userNames',
    width: '5%'
  },
  {
    title: '辨识方法',
    dataIndex: 'identificationMethodNames',
    key: 'identificationMethodNames',
    width: '5%'
  },
  {
    title: '初评人',
    dataIndex: 'firstEvaluateUserName',
    key: 'firstEvaluateUserName',
    width: '5%'
  },
  {
    title: '初评方法',
    dataIndex: 'firstEvaluateMothodName',
    key: 'firstEvaluateMothodName',
    width: '5%'
  },
  {
    title: '复评人',
    dataIndex: 'secondEvaluateUserName',
    key: 'secondEvaluateUserName',
    width: '5%'
  },
  {
    title: '复评方法',
    dataIndex: 'secondEvaluateMothodName',
    key: 'secondEvaluateMothodName',
    width: '5%'
  },
  {
    title: '危险源分类',
    dataIndex: 'hazardSourceClassifyName',
    key: 'hazardSourceClassifyName',
    width: '5%'
  },
  {
    title: '可能造成的后果',
    dataIndex: 'aftermathNames',
    key: 'aftermathNames',
    width: '5%'
  },
  {
    title: '控制措施类别',
    dataIndex: 'controlMeasureName',
    key: 'controlMeasureName',
    width: '5%'
  },
  {
    title: '控制措施详情',
    dataIndex: 'controlMeasureDetail',
    key: 'controlMeasureDetail',
    width: '5%'
  },
  {
    title: '风险类型',
    dataIndex: 'riskType',
    key: 'riskType',
    width: '5%'
  },
  {
    title: '更新时间',
    dataIndex: 'updateDate',
    key: 'updateDate',
    width: '5%',
    render: (text) => {return text ? moment(text).format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');}
  }
];

/**
 *  设备设施危险源清单
 */
const equipRiskSourceListHeader = [
  {
    title: '危险源名称',
    dataIndex: 'name',
    key: 'name',
    width: '10%'
  },
  {
    title: '风险等级',
    dataIndex: 'levelName',
    key: 'levelName',
    width: '10%'
  },
  {
    title: '设备位号',
    dataIndex: 'equipmentCode',
    key: 'equipmentCode',
    width: '10%'
  },
  {
    title: '设备名称',
    dataIndex: 'equipmentName',
    key: 'equipmentName',
    width: '10%'
  },
  {
    title: '所属工段',
    dataIndex: 'workshopSection',
    key: 'workshopSection',
    width: '10%'
  },
  {
    title: '部门/车间',
    dataIndex: 'departmentName',
    key: 'departmentName',
    width: '10%'
  },
  {
    title: '所在分区',
    dataIndex: 'regionName',
    key: 'regionName',
    width: '10%'
  },
  {
    title: '辨识人',
    dataIndex: 'identificationUserName',
    key: 'identificationUserName',
    width: '10%'
  },
  {
    title: '辨识方法',
    dataIndex: 'identificationMethodName',
    key: 'identificationMethodName',
    width: '10%'
  },
  {
    title: '更新时间',
    dataIndex: 'updateDate',
    key: 'updateDate',
    width: '10%',
    render: (text) => {return text ? moment(text).format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');}
  }
];

/**
 * 重大危险源清单
 */
const majorHazardsListHeader = [
  {
    title: '序号',
    render: (text, record, index) => `${index + 1}`
  },
  {
    title: '重大危险源名称',
    dataIndex: 'name',
    key: 'name',
    width: '20%'
  },
  {
    title: '风险区域',
    dataIndex: 'riskSourceName',
    key: 'riskSourceName',
    width: '20%'
  },
  {
    title: '辨识方法',
    dataIndex: 'identificationMethodName',
    key: 'identificationMethodName',
    width: '20%'
  },
  {
    title: '辨识人',
    dataIndex: 'identificationUserName',
    key: 'identificationUserName',
    width: '20%'
  },
  {
    title: '级别',
    dataIndex: 'riskLevelName',
    key: 'riskLevelName',
    width: '10%'
  }
];

/**
 * 风险区域清单
 */
const riskAreaListHeader = [
  {
    title: '风险区域名称',
    dataIndex: 'name',
    key: 'name',
    width: '20%'
  },
  {
    title: '风险等级',
    dataIndex: 'levelName',
    key: 'levelName',
    width: '10%'
  },
  {
    title: '风险点名称',
    dataIndex: 'subName',
    key: 'subName',
    width: '20%'
  },
  {
    title: '辨识人',
    dataIndex: 'identificationUserName',
    key: 'identificationUserName',
    width: '10%'
  },
  {
    title: '辨识方法',
    dataIndex: 'identificationMethodName',
    key: 'identificationMethodName',
    width: '20%'
  },
  {
    title: '更新时间',
    dataIndex: 'updateDate',
    key: 'updateDate',
    width: '20%',
    render: (text) => {return text ? moment(text).format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');}
  }
];

/**
 * 风险位置清单
 */
const riskPositionListHeader = [
  {
    title: '风险点名称',
    dataIndex: 'name',
    key: 'name',
    width: '15%'
  },
  {
    title: '风险等级',
    dataIndex: 'levelName',
    key: 'levelName',
    width: '15%'
  },
  {
    title: '危险源名称',
    dataIndex: 'subName',
    key: 'subName',
    width: '15%'
  },
  {
    title: '辨识人',
    dataIndex: 'identificationUserName',
    key: 'identificationUserName',
    width: '15%'
  },
  {
    title: '辨识方法',
    dataIndex: 'identificationMethodName',
    key: 'identificationMethodName',
    width: '10%'
  },
  {
    title: '更新时间',
    dataIndex: 'password',
    key: 'password',
    width: '10%',
    render: (text) => {return text ? moment(text).format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');}
  }
];

/**
 *
 * 作业活动危险因素清单
 */
const taskworkRiskFactorListHeader = [
  {
    title: '危险因素名称',
    dataIndex: 'cameraCode',
    key: 'cameraCode',
    width: '5%'
  },
  {
    title: '风险等级',
    dataIndex: 'level',
    key: 'level',
    width: '5%'
  },
  {
    title: '作业活动步骤',
    dataIndex: 'stepName',
    key: 'stepName',
    width: '5%'
  },
  {
    title: '步骤顺序',
    dataIndex: 'cameraIP',
    key: 'cameraIP',
    width: '5%'
  },
  {
    title: '危险源名称',
    dataIndex: 'loginName',
    key: 'loginName',
    width: '5%'
  },
  {
    title: '作业活动名称',
    dataIndex: 'password',
    key: 'password',
    width: '5%'
  },
  {
    title: '作业活动岗位',
    dataIndex: 'port',
    key: 'port',
    width: '5%'
  },
  {
    title: '作业活动部位',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '辨识人',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '辨识方法',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '初评人',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '初评方法',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '复评人',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '复评方法',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '危险源分类',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '可能造成的后果',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '控制措施类别',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '控制措施名称',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '控制措施详情',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '风险类型',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  },
  {
    title: '更新时间',
    dataIndex: 'path',
    key: 'path',
    width: '5%'
  }
];

/**
 *
 * 作业活动危险因素清单
 */
const taskworkRiskSourceListHeader = [
  {
    title: '危险源名称',
    dataIndex: 'cameraCode',
    key: 'cameraCode',
    width: '15%'
  },
  {
    title: '风险等级',
    dataIndex: 'cameraName',
    key: 'cameraName',
    width: '15%'
  },
  {
    title: '作业活动名称',
    dataIndex: 'cameraType',
    key: 'cameraType',
    width: '15%'
  },
  {
    title: '作业活动岗位',
    dataIndex: 'cameraIP',
    key: 'cameraIP',
    width: '15%'
  },
  {
    title: '作业活动岗位',
    dataIndex: 'loginName',
    key: 'loginName',
    width: '10%'
  },
  {
    title: '辨识人',
    dataIndex: 'password',
    key: 'password',
    width: '10%'
  },
  {
    title: '辨识方法',
    dataIndex: 'port',
    key: 'port',
    width: '10%'
  },
  {
    title: '更新时间',
    dataIndex: 'path',
    key: 'path',
    width: '10%'
  }
];

export const tabConf = [
  { id: '1', closable: false, title: '风险区域清单',header: riskAreaListHeader },
  { id: '2', closable: false, title: '风险点清单',header: riskPositionListHeader },
  { id: '3', closable: false, title: '设备设施危险源清单',header: equipRiskSourceListHeader },
  { id: '4', closable: false, title: '设备设施危险因素清单' ,header: equipRiskFactorListHeader },
  // { id: '5', closable: false, title: '作业活动危险源清单' ,header: taskworkRiskSourceListHeader },
  // { id: '6', closable: false, title: '作业活动危险因素清单' ,header: taskworkRiskFactorListHeader },
  { id: '7', closable: false, title: '重大危险源清单' ,header: majorHazardsListHeader },
  { id: '8', closable: false, title: '危险源二维码清单' }
];
