import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { TreeSelect } from 'amos-antd';
import { Input, Form, Button, Select } from 'amos-framework';

const FormItem = Form.Item;
const Option = Select.Option;
/**
 *
 *风险区域查询条件
 * @class RiskAreaListSearch
 * @extends {Component}
 */
class RiskAreaListSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        subName: {
          name: 'subName',
          type: 'LIKE',
          value: ''
        },
        riskLevel: {
          name: 'riskLevel',
          type: 'EQUAL',
          value: ''
        },
        identificationMethodId: {
          name: 'identificationMethodId',
          type: 'EQUAL',
          value: ''
        },
        userId: {
          name: 'userId',
          type: 'EQUAL',
          value: ''
        },
        beginDate: {
          name: 'beginDate',
          type: 'EQUAL',
          value: ''
        },
        endDate: {
          name: 'endDate',
          type: 'EQUAL',
          value: ''
        }
      },
      levelData: []
    };
  }

  componentWillMount() {}

  componentDidMount() {
  }

  onInputChange = (key, value) => {
    const { form } = this.state;
    form[key].value = value;
    this.setState({ form });
  };

  onClick = () => {
    const { form } = this.state;
    this.props.search(form);
  };

  onSelectChange = (key, value, t, obj) => {
    const { form } = this.state;
    if (obj && obj.triggerNode && obj.triggerNode.props && obj.triggerNode.props.type === 'department') {
      return;
    }
    if (obj && obj.triggerNode && obj.triggerNode.props && obj.triggerNode.props.type === 'model') {
      return;
    }
    form[key].value = value;
    this.setState({ form });
  };

  initFormValues = () => {
    const { form } = this.state;
    for (let key in form) {
      form[key].value = '';
    }
    this.setState({ form });
  };

  render() {
    let { form, levelData } = this.state;
    const { searchCommonData } = this.props;
    levelData = searchCommonData && searchCommonData.riskLevelData;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    const wrapperCol = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 14, offset: 10 }
      }
    };
    return (
      <Form className="risk-list-search" model={form}>
        <FormItem label={<span>风险区域名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="risk-list-input" onChange={e => this.onInputChange('name', e.target.value)} />
        </FormItem>
        <FormItem label={<span>风险点名称</span>} field="subName" {...formItemLayout}>
          <Input value={form.subName.value} className="risk-list-input" onChange={e => this.onInputChange('subName', e.target.value)} />
        </FormItem>
        <FormItem label={<span>风险等级</span>} field="riskLevel" {...formItemLayout}>
          <TreeSelect
            value={form.riskLevel.value === 0 ? undefined : form.riskLevel.value}
            className="risk-list-select"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={levelData || []}
            placeholder="请选择"
            allowClear
            showSearch
            treeNodeFilterProp={'title'}
            treeDefaultExpandAll
            onChange={(e, t, obj) => this.onSelectChange('riskLevel', e, t, obj)}
          />
        </FormItem>
        <FormItem label={<span>辨识方法</span>} field="identificationMethodId" {...formItemLayout}>
          <Select
            className="risk-model-select"
            allowClear
            data={searchCommonData.methodData || []}
            renderOption={item => <Option value={parseInt(item.id)}>{item.name}</Option>}
            values={form.identificationMethodId.value}
            onChange={value => this.onSelectChange('identificationMethodId', value)}
          />
        </FormItem>
        <FormItem label={<span>辨识人</span>} field="userId" {...formItemLayout}>
          <TreeSelect
            value={form.userId.value === 0 ? undefined : form.userId.value}
            className="risk-list-select"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={searchCommonData.userData || []}
            placeholder="请选择"
            allowClear
            showSearch
            treeNodeFilterProp={'title'}
            treeDefaultExpandAll
            onChange={(e, t, obj) => this.onSelectChange('userId', e, t, obj)}
          />
        </FormItem>
        <FormItem {...wrapperCol}>
          <Button onClick={this.onClick} className="risk-list-search-button">
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

RiskAreaListSearch.propTypes = {
  search: PropTypes.func,
  searchCommonData: PropTypes.object
};

export default RiskAreaListSearch;
