import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Popover } from 'amos-framework';
import PointQRCode from './PointQRCode';

/**
 * 二维码提示
 *
 * @class QRDetailPopover
 * @extends {Component}
 */
class QRDetailPopover extends Component {
  constructor(props) {
    super(props);

  }

  componentWillMount() {

  }

  componentDidMount() {

  }

  render() {
    const { record } = this.props;
    return (
      <Popover
        content={<PointQRCode pointQRInfo={record} />}
        destroyContent
        direction="down"
        className='qr-detail-popover'
      >
        <span style={{ color: '#42a5f5',cursor: 'pointer' }}>查看</span>
      </Popover>
    );
  }
}

QRDetailPopover.propTypes = {
  record: PropTypes.object
};

export default QRDetailPopover;
