import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { SplitPane } from 'amos-framework';

class RiskEvaluation extends Component {
  constructor(props) {
    super(props);
  }

  render() {
    const { code ,riskLevel,riskLevelData = [] } = this.props;
    const index = riskLevelData.findIndex(e=>e.id === parseInt(riskLevel) );
    const levelName = index >= 0 ? riskLevelData[index].level : '';
    return (
      <div  className='risk-model-eva'>
        <span className='risk-eva-span'>风险评价</span>
        <div  className='risk-model-eva-con'>
          <SplitPane percentage  mainPaneIndex={0} secondaryDefaultSize={50}>
            <div className="risk-model-eva-con-one">
              <div className="con-eva-key">编号 </div>
              <div className="con-eva-value">{code || ''}</div>
            </div>
            <div className="risk-model-eva-con-two" >
              <div className="con-eva-key">等级</div>
              <div className="con-eva-value">{ levelName }</div>
            </div>
          </SplitPane>
        </div>
      </div>
    );
  }
}

RiskEvaluation.propTypes = {
  code: PropTypes.String,
  riskLevel: PropTypes.String,
  riskLevelData: PropTypes.array
};

export default RiskEvaluation;
