import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import BizIcon from './../../../common/icon/BizIcon';

/**
 * 工具栏
 *
 * @class EquipFacilitiesToolBar
 * @extends {Component}
 */

class EquipFacilitiesToolBar extends Component {
  constructor(props) {
    super(props);
  }

  componentWillMount() {

  }

  render() {
    return (
      <div className="important-equipment-toolbar fire-truck-toolbar">
        <div className='important-equipment-title'>
          <span>设备设施</span>
        </div>
        <div className="important-equipment-tools fire-truck-buttons">
          <Button title="添加" icon={<BizIcon icon="tianjia" />} transparent onClick={this.props.add} />
          <Button title="修改" icon={<BizIcon icon="xiugai" />} transparent onClick={this.props.edit} />
          <Button title="删除" icon={<BizIcon icon="shanchu" />} transparent onClick={this.props.delete} />
          <Button title="筛选" icon={<BizIcon icon="shaixuan" />} transparent onClick={this.props.filter} />
        </div>
      </div>
    );
  }
}

EquipFacilitiesToolBar.propTypes = {
  add: PropTypes.func,
  edit: PropTypes.func,
  delete: PropTypes.func,
  filter: PropTypes.func
};

export default EquipFacilitiesToolBar;
