import React, { Component } from 'react';
import { Button } from 'amos-framework';
import  PropTypes from 'prop-types';
import TaskWorkSearch from './TaskWorkSearch';

class SearchView extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {}

  onClick = () => {
    const { search } = this.props;
    search && search(this.search.state.form);
  }

  getRenderContent = () => {
    const { typeData, regionDepartmentTree } = this.props;
    return <TaskWorkSearch typeData={typeData} regionDepartmentTree={regionDepartmentTree} ref={node => this.search = node} />;
  }

  render() {
    return (
      <div className='search-view'>
        {this.getRenderContent()}
        <div className='search-view-buttons' style={{ textAlign: 'center' }}>
          <Button onClick={() => this.onClick()} style={{ background: '#19afff' }}>查询</Button>
          <Button onClick={() => this.search.onInitForm()} style={{ background: 'transparent', marginLeft: '0.8rem !important', color: 'black' }}>重置</Button>
        </div>
      </div>
    );
  }
}

SearchView.propTypes = {
  search: PropTypes.func,
  typeData: PropTypes.array,
  regionDepartmentTree: PropTypes.obj
};
export default SearchView;
