import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import BizIcon from './../../../common/icon/BizIcon';

/**
 * 工具栏
 *
 * @class EquipFacilitiesToolBar
 * @extends {Component}
 */

class EquipFacilitiesToolBar extends Component {
  constructor(props) {
    super(props);
  }

  componentWillMount() {

  }

  onChange = (e, value) => {
    let { getTableListData, pageConfig } = this.props;
    this.setState({ name: value });
    let searchParam = [{ name: e, value }];
    searchParam.pageNumber = pageConfig.pageNumber;
    searchParam.pageSize = pageConfig.pageSize;
    getTableListData(searchParam);
  };

  render() {
    return (
      <div className="important-equipment-toolbar fire-truck-toolbar">
        <div className='important-equipment-title'>
          <span>作业活动</span>
        </div>
        <div className="important-equipment-tools fire-truck-buttons">
          <Button title='添加' icon={<BizIcon icon="tianjia" />} transparent onClick={this.props.add} />
          <Button title='修改' icon={<BizIcon icon="xiugai" />} transparent onClick={this.props.edit} />
          <Button title='删除' icon={<BizIcon icon="shanchu" />} transparent onClick={this.props.delete} />
          <Button title='发起流程' icon={<BizIcon icon="liucheng" />} transparent onClick={this.props.startProcess} />
          <Button title='流程查看' icon={<BizIcon icon="liuchengtuliuchengzhuangtai" />} transparent onClick={this.props.showProcess} />
          <Button title='筛选' icon={<BizIcon icon="shaixuan" />} transparent onClick={this.props.filter} />
        </div>
      </div>
    );
  }
}

EquipFacilitiesToolBar.propTypes = {
  add: PropTypes.func,
  edit: PropTypes.func,
  delete: PropTypes.func,
  filter: PropTypes.func,
  getTableListData: PropTypes.func,
  pageConfig: PropTypes.object,
  startProcess: PropTypes.func,
  showProcess: PropTypes.func
};

export default EquipFacilitiesToolBar;
