import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input, Form } from 'amos-framework';

const FormItem = Form.Item;

/**
 * 可能造成后果查询页面
 *
 * @class PossibleConsequenceSearch
 * @extends {Component}
 */
class PossibleConsequenceSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: {
          name: 'name',
          type: 'LIKE',
          value: ''
        },
        describe: {
          name: 'describe',
          type: 'LIKE',
          value: ''
        }
      }
    };
  }

  componentDidMount() {

  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState({ form });
  };

  initSearchFileds = () => {
    let { form } = this.state;
    for (let k in form) {
      form[k].value = '';
    }
    this.setState({ form });
  }

  render() {
    const { form } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 6 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0px', marginLeft: 'auto' }} className="point-search" model={form}>
        <FormItem label={<span>后果名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label={<span>备注</span>} field="describe" {...formItemLayout}>
          <Input value={form.describe.value} className="search_Input" onChange={e => this.onChange('describe', e)} />
        </FormItem>
      </Form>
    );
  }
}

PossibleConsequenceSearch.propTypes = {

};

export default PossibleConsequenceSearch;
