import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosGridTable from './../../../common/tableComponent/table/AmosGridTable';

const getColumns = (self) => {
  return [
    {
      title: '描述',
      dataIndex: 'description',
      key: 'description',
      width: '30%',
      className: 'uant-table-thead'
    },
    {
      title: '评分标准',
      dataIndex: 'standard',
      key: 'standard',
      width: '50%',
      className: 'uant-table-thead'
    },
    {
      title: '分值',
      dataIndex: 'score',
      key: 'score',
      width: '12%',
      className: 'uant-table-thead'
    }
  ];
};

/**
 * 风险评价准则查看
 */
class EvaluationCriteriaView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: '',
        evaluateModelId: -1,
        criteriation: []
      }
    };
  }

  componentWillMount = () => {
    const { selectRowData } = this.props || {};
    if (selectRowData) {
      let form = {};
      Object.assign(form, selectRowData);
      form.criteriation = JSON.parse(selectRowData.content);
      this.setState({ form });
    }
  };

  render() {
    const { form } = this.state;

    return (
      <div>
        <div style={{ paddingBottom: '15px' }}>
          <span>准则名称：</span>
          <span>{form.name}</span>
        </div>
        <div>
          <AmosGridTable
            rowKey="key"
            columns={getColumns(this)}
            callBack={() => {}}
            dataList={form.criteriation || []}
            getTableDataAction={() => {}}
            isChecked={false}
            isPageable={false}
          />
        </div>
      </div>
    );
  }
}

EvaluationCriteriaView.propTypes = {
  reloadPage: PropTypes.func
};
export default EvaluationCriteriaView;
