import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button, Select } from 'amos-framework';
import BizIcon from './../../../../common/icon/BizIcon';
import { getEvaluateModelListAction } from './../../../../../services/bizService';

const Option = Select.Option;

/**
 * 工具栏
 *
 * @class EvaluationCriteriaToolBar
 * @extends {Component}
 */
class EvaluationCriteriaToolBar extends Component {
  constructor(props) {
    super(props);
    this.state = {
      evaluationModelId: this.props.evaModel && this.props.evaModel.id,
      evaluateModelData: []
    };
  }

  componentWillMount() {
    this.getEvaluateModelList();
  }

  onClick = (e, value) => {
    let { onButtonClick } = this.props;
    onButtonClick(value);
  };

  onSelectChange = (value, obj) => {
    this.setState({ evaluationModelId: value });
    this.props.onEvaModelSelectChange(obj);
  }

  getEvaluateModelList = () => {
    getEvaluateModelListAction([], 0, -1).then(data => {
      this.setState({ evaluateModelData: data });
      let evaModel = this.props.evaModel;
      if (evaModel) {
        this.props.onEvaModelSelectChange(evaModel);
      } else {
        data[0] && this.props.onEvaModelSelectChange(data[0]);
      }
    });
  }

  render() {
    let { evaluationModelId, evaluateModelData } = this.state;
    return (
      <div className="risk-lever-toolbar">
        <div className="risk-lever-select">
          <span>风险评价模型：</span>
          <Select
            data={evaluateModelData}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            value={evaluationModelId || (evaluateModelData[0] && evaluateModelData[0].id)}
            onChange={(value, obj) => this.onSelectChange(value, obj)}
          />
        </div>
        <div className="risk-lever-button">
          <Button title="添加" icon={<BizIcon icon="tianjia" />} transparent onClick={e => this.onClick(e, '1')} />
          <Button title="修改" icon={<BizIcon icon="xiugai" />} transparent onClick={e => this.onClick(e, '2')} />
          <Button title="删除" icon={<BizIcon icon="shanchu" />} transparent onClick={e => this.onClick(e, '3')} />
          <Button title="筛选" icon={<BizIcon icon="shaixuan" />} transparent onClick={e => this.onClick(e, '4')} />
        </div>
      </div>
    );
  }
}

EvaluationCriteriaToolBar.propTypes = {
  onButtonClick: PropTypes.func,
  onEvaModelSelectChange: PropTypes.func,
  evaModel: PropTypes.object
};

export default EvaluationCriteriaToolBar;
