import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, AmosAlert, Input } from 'amos-framework';
import { evaluateModelSaveAction } from '../../../../../services/bizService';

const FormItem = Form.Item;

/**
 * 风险评价模型新增及编辑
 */
class EvaluationModel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: ''
      },
      rules: {
        name: [{ required: true, message: '风险评价方法不能为空' },{ max: 50, message: '长度不能大于50个字符',}]
      }
    };
  }

  componentWillMount = () => {
    const { selectRowData } = this.props || {};
    if (selectRowData) {
      let form = {};
      Object.assign(form, selectRowData);
      this.setState({ form });
    }
  };

  onInputChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  };

  handleSubmit = e => {
    this.form.validate((valid, dataValues) => {
      if (valid) {
        let { form } = this.state;
        this.evaluateModelSave(form);
      } else {
        return false;
      }
    });
  };

  evaluateModelSave = body => {
    evaluateModelSaveAction(body).then(
      data => {
        AmosAlert.success('提示', '操作成功');
        this.props.reloadPage();
      },
      err => {
        AmosAlert.error('提示', err);
      }
    );
  };

  render() {
    const { form, rules } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <div>
        <Form model={form} rules={rules} ref={component => this.form = component}>
          <FormItem label={<span>风险评价方法</span>} field="name" {...formItemLayout}>
            <Input className="risk_factor_input" value={form.name} onChange={e => this.onInputChange('name', e.target.value)} />
          </FormItem>
        </Form>
      </div>
    );
  }
}

EvaluationModel.propTypes = {
  reloadPage: PropTypes.func
};
export default EvaluationModel;
