import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select, Input, Button } from 'amos-framework';
import { DatePicker } from 'amos-antd';
import { areaPlistNoPageAction, equipNoPageAction } from '../../../../services/ledgerService';
import BizIcon from './../../../common/icon/BizIcon';

const { RangePicker } = DatePicker;
const Option = Select.Option;
/**
 * 报警查询条件
 */

class AlarmSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: {},
      areaData: [],
      equipData: []
    };
  }

  componentDidMount() {
    // this.queryAreaPlist();
    this.queryEquipList();
  }

  onSelectChange = (type, value, obj) => {
    let { searchParam } = this.state;
    let param = {};
    if (type === 'time') {
      let startTime;
      let endTime;
      if (value.length !== 0) {
        startTime = value[0].format('YYYY-MM-DD HH:mm:ss');
        endTime = value[1].format('YYYY-MM-DD HH:mm:ss');
      }
      param = { startTime,  endTime };
    } else {
      param[type] = obj.name;
    }
    Object.assign(searchParam, param);
    this.setState({ searchParam });
    this.props.setSearchParam(searchParam);
  };

  onChange = (e, value) => {
    let { searchParam } = this.state;
    Object.assign(searchParam, { [e]: value });
    this.setState(searchParam);
  };

  // queryAreaPlist = () => {
  //   areaPlistNoPageAction().then(data => {
  //     this.setState({ areaData: data });
  //   });
  // };

  queryEquipList = () => {
    equipNoPageAction().then(data => {
      this.setState({ equipData: data });
    });
  };

  searchData = () => {
    debugger
    let { searchParam } = this.state;
    this.props.setSearchParam(searchParam);
  };

  render() {
    let { equipData, searchParam } = this.state;
    return (
      <div className="alarm-view-search">
        {/*<div className="alarm-view-select-1">
          <span>建/构筑物：</span>
          <Select
            className="alarm-view-select"
            data={areaData}
            defaultOption={<Option>请选择</Option>}
            renderOption={item => <Option value={item}>{item}</Option>}
            onChange={e => this.onSelectChange('productArea', e)}
          />
        </div>*/}
        <div className="alarm-view-select-2">
          <span>保护对象：</span>
          <Select
            className="alarm-view-select"
            data={equipData}
            defaultOption={<Option>请选择</Option>}
            renderOption={item => <Option value={parseInt(item.id)}>{item.name}</Option>}
            onChange={(e,o) => this.onSelectChange('equipmentName', e, o)}
          />
        </div>
        <div className="alarm-view-select-3">
          <span>报警时间：</span>
          <RangePicker onChange={e => this.onSelectChange('time', e)} />
        </div>
        <div className="alarm-view-input">
          <span>名称：</span>
          <Input value={searchParam.fireEquipmentName} onChange={e => this.onChange('fireEquipmentName', e.target.value)} />
          <Button icon={<BizIcon icon='sousuo' />} transparent onClick={this.searchData} />
        </div>
      </div>
    );
  }
}

AlarmSearch.propTypes = {
  setSearchParam: PropTypes.func
};
export default AlarmSearch;
