import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { Tooltip } from 'amos-framework';

/**
 * 方块
 *
 * @class Diamond
 * @extends {Component}
 */
class Diamond extends Component {
  constructor(props) {
    super(props);

  }

  componentWillMount() {

  }

  componentDidMount() {

  }

  render() {
    const { data: { status,name } } = this.props;
    const cls1 = classNames({
      'diamond-popover': true,
      [`point-status_${status}`]: true
    });
    const cls2 = classNames({
      'diamond-item': true,
      [`point-status_${status}`]: true
    });
    return (
      <Tooltip title={name} className={cls1} ><div className={cls2} /></Tooltip>
    );
  }
}

Diamond.propTypes = {
  data: PropTypes.object
};

export default Diamond;
