import React, { Component } from 'react';
import AmosEcharts from 'amos-viz/lib/echarts';
import moment from 'moment';
import BizIcon from '../../../../view/common/icon/BizIcon';

class IndexTrendCurve extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data1: [10, 15, 20, 25, 30, 35, 30, 25, 20, 15, 10, 10, 15, 20, 25, 30, 35, 30, 25, 15, 25, 10, 20, 10],
      data2: [50, 51, 52, 53, 54, 55, 53, 50, 51, 55, 60, 50, 60, 50, 60, 55, 60, 50, 60, 60, 60, 50, 60, 50],
      data3: [70, 80, 80, 80, 80, 75, 80, 70, 80, 80, 80, 70, 80, 70, 80, 75, 80, 70, 80, 80, 80, 70, 80, 70],
      data4: [100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100],
      data5: [20, 19, 18, 17, 16, 15, 20, 21, 22, 23, 25, 20, 18, 15, 20, 17, 16, 15, 20, 25, 25, 20, 22, 15],
      data6: [25, 30, 30, 20, 35, 21, 25, 26, 20, 20, 20, 21, 20, 26, 25, 31, 25, 26, 35, 20, 20, 21, 20, 26],
      labalData: []
    };
  }

  componentDidMount() {
    this.registerTimer();
    this.getHours();
  }

  registerTimer = () => {
    this.timer && clearTimeout(this.timer);
    this.changeData();
    this.timer = setTimeout(() => this.registerTimer(), 15 * 1000);
  }

  getHours = () => {
    let interval = 1;
    let array =  [];
    while (array.length <= 24) {
      let begin = moment().add(interval, 'hours').hours();
      array.push(begin+':00');
      interval = interval + 1;
    }
    this.setState({ labalData: array });
  }

  changeData = () => {
    let { data1, data2, data3, data4, data5, data6 } = this.state;
    let newNumber1 = data1[0];
    let newNumber2 = data2[0];
    let newNumber3 = data3[0];
    let newNumber4 = data4[0];
    let newNumber5 = data5[0];
    let newNumber6 = data6[0];
    data1.splice(0,1);
    data1.push(newNumber1);
    data2.splice(0,1);
    data2.push(newNumber2);
    data3.splice(0,1);
    data3.push(newNumber3);
    data4.splice(0,1);
    data4.push(newNumber4);
    data5.splice(0,1);
    data5.push(newNumber5);
    data6.splice(0,1);
    data6.push(newNumber6);
    this.setState({ data1, data2, data3, data4, data5, data6 });
  }

  getOptions = () => {
    let { data1, data2, data3, data4, data5, data6, labalData } = this.state;
    return {
      color: ['green', '#4cdbff', '#ffff4c', 'red', '#66ff00', '#330066'],
      tooltip: {
        trigger: 'axis'
      },
      legend: {
        show: true,
        bottom: '10px',
        data:['预警等级','安全','注意','告警','实际安全指数', '预测安全指数']
      },
      grid: {},
      toolbox: {
        feature: {
          saveAsImage: {}
        }
      },
      xAxis: {
        type: 'category',
        axisLabel: {
          interval: 0
        },
        data: labalData
      },
      yAxis: {
        type: 'value',
        name: '指标值'
      },
      series: [{
        name: '预警等级',
        type: 'line',
        step: 'start',
        lineStyle: {
          normal: {
            opacity: 0
          }
        },
        itemStyle: {
          normal: {
            opacity: 0
          }
        },
        areaStyle: {
          normal: {
            opacity: 1
          }
        },
        z: 4,
        data: data1
      }, {
        name: '安全',
        type: 'line',
        step: 'start',
        z: 3,
        lineStyle: {
          normal: {
            opacity: 0
          }
        },
        itemStyle: {
          normal: {
            opacity: 0
          }
        },
        areaStyle: {
          normal: {
            opacity: 1
          }
        },
        data: data2
      }, {
        name: '注意',
        type: 'line',
        step: 'start',
        z: 2,
        lineStyle: {
          normal: {
            opacity: 0
          }
        },
        itemStyle: {
          normal: {
            opacity: 0
          }
        },
        areaStyle: {
          normal: {
            opacity: 1
          }
        },
        data: data3
      }, {
        name: '告警',
        type: 'line',
        step: 'start',
        lineStyle: {
          normal: {
            opacity: 0
          }
        },
        itemStyle: {
          normal: {
            opacity: 0
          }
        },
        areaStyle: {
          normal: {
            opacity: 1
          }
        },
        z: 1,
        data: data4
      }, {
        name: '实际安全指数',
        type: 'line',
        z: 5,
        data: data5
      }, {
        name: '预测安全指数',
        type: 'line',
        z: 6,
        lineStyle: {
          normal: {
            type: 'dashed'
          }
        },
        data: data6
      }]
    };
  }

  render() {
    return (
      <div className="index-trend-curve" style={{ height: '90%' }}>
        <div className="title">
          <BizIcon icon='mokuaidian' className='check-execute-header-icon' />
          <span>安全预警指数趋势图</span>
        </div>
        <AmosEcharts option={this.getOptions()} />
      </div>
    );
  }
}

IndexTrendCurve.propTypes = {

};

export default IndexTrendCurve;
