import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import { fetchMonthCountChkAction } from './../../../services/checkInfoService';
import moment from 'moment';
/**
 * 本月隐患治理趋势统计
 * @class MonthDangerCount
 * @extends {Component}
 */
class MonthDangerCount extends Component {
  constructor(props) {
    super(props);
    this.state = {
      xList: [],
      proData: [],
      actData: [],
      forData: []
    };
  }
  getOptions(xList, canelData, finishData, timeOutData, countDate) {
    return {
      tooltip: {
        trigger: 'axis',
        showDelay: 0,
        backgroundColor: 'rgba(34, 34, 34, 1)',
        hideDelay: 50,
        transitionDuration: 0,
        position: function(p) {
          return [p[0] + 10, p[1] - 10];
        },
        textStyle: {
          color: '#ffffff',
          decoration: 'none',
          fontFamily: 'Verdana, sans-serif',
          fontSize: 12,
          fontStyle: 'normal',
          fontWeight: 'normal'
        },
        formatter: function(params, ticket, callback) {
          let countDate = moment().format('YYYYMM');
          let day = '0' + params[0].name;
          let res = countDate + day.substr(day.length - 2, 2);
          for (let i = 0, l = params.length; i < l; i++) {
            if (params[i].seriesIndex === 0) {
              res += '<br/><span style="color:#41d0f4;">' + params[i].seriesName + ' : ' + params[i].value + '</span>';
            } else if (params[i].seriesIndex === 1) {
              res += '<br/><span style="color:#66cc00;">' + params[i].seriesName + ' : ' + params[i].value + '</span>';
            } else if (params[i].seriesIndex === 2) {
              res += '<br/><span style="color:#ffcc00;">' + params[i].seriesName + ' : ' + params[i].value + '</span>';
            }
          }
          return res;
        },
        axisPointer: {
          type: 'line',
          lineStyle: {
            color: 'rgba(34, 34, 34, 1)',
            width: 2,
            type: 'solid'
          }
        }
      },
      color: ['#41d0f4', '#66cc00', '#ffcc00'],//['#00FFFF', '#00FF00', '#FF0000'],
      legend: {
        show: true,
        y: 'top',
        x: 'right',
        textStyle: {
          color: 'auto'
        },
        data: [
          {
            name: '已取消',
            icon: 'diamond',
            textStyle: { color: '#41d0f4' }
          },
          {
            name: '已完成',
            icon: 'diamond',
            textStyle: { color: '#66cc00' }
          },
          {
            name: '已超时',
            icon: 'diamond',
            textStyle: { color: '#ffcc00' }
          }
        ]
      },
      grid: {
        x: '10%',
        y: '10%',
        y2: '30%',
        x2: '5%'
      },
      xAxis: [
        {
          type: 'category',
          boundaryGap: false,
          data: xList,
          axisLabel: {
            show: true,
            interval: 0,
            textStyle: {
              color: 'black' //'#FFFFFF'
            }
          },
          splitLine: {
            lineStyle: {
              color: ['#FFFFFF']
            }
          }
        }
      ],
      yAxis: [
        {
          type: 'value',
          axisLabel: {
            textStyle: {
              color: 'black' //'#FFFFFF'
            }
          },
          splitLine: {
            show: true,
            lineStyle: {
              type: 'dashed',
              width: 2,
              color: '#c9c9c9' //'rgba(34, 34, 34, 1)'
            }
          }
        }
      ],
      series: [
        {
          name: '已取消',
          type: 'line',
          data: canelData,
          smooth: true,
          symbol: 'none',
          itemStyle: {
            normal: {
              lineStyle: {
                color: '#41d0f4'//'#00FFFF'
              }
            }
          }
        },
        {
          name: '已完成',
          type: 'line',
          data: finishData,
          symbol: 'none',
          smooth: true,
          itemStyle: {
            normal: {
              lineStyle: {
                color: '#66cc00'//'#00FF00'
              }
            }
          }
        },
        {
          name: '已超时',
          type: 'line',
          data: timeOutData,
          symbol: 'none',
          smooth: true,
          itemStyle: {
            normal: {
              lineStyle: {
                color: '#ffcc00'//'#FF0000'
              }
            }
          }
        }
      ]
    };
  }

  render() {
    let { monData } = this.props;
    let canelData = [];
    let finishData = [];
    let timeOutData = [];
    let xList = [];
    monData &&
      monData.map(e => {
        canelData.push(e.canelNum);
        finishData.push(e.finishNum);
        timeOutData.push(e.timeOutNum);
        xList.push(e.date);
      });
    const option = this.getOptions(xList, canelData, finishData, timeOutData);
    return (
      <div className="danger-month-ins">
        <div className="danger-month-ins-title">本月隐患治理趋势统计</div>
        <AmosEcharts option={option} />
      </div>
    );
  }
}

MonthDangerCount.propTypes = {};

MonthDangerCount.defaultProps = {
  data: {},
  legend: [],
  chartStyle: { width: '100%', height: '20rem' }
};

export default MonthDangerCount;
