import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { browserHistory } from 'amos-react-router';
import dt2react from 'dt2react';
import { fetchTaskListAction } from './../../../services/checkInfoService';
import AmosGridTable from './../common/tableComponent/table/AmosGridTable';
import { pathMapping } from './../../../routes/customRoutes';
import {renderLongTime} from './../../bizview/common/tableComponent/tool';
import TaskSearch from './taskSearch'

// const CheckListPath = pathMapping.pointCheckList;
const taskStatusEnum = {0:'处理中', 1:'已完成',2 : '已取消',3:'已超时'};
const taskListColumns = () => {
  return [
    {
      title: '标题',
      dataIndex: 'title',
      key: 'title',
      width: '10%'
    },
    {
      title: '安排人',
      dataIndex: 'publisherName',
      key: 'publisherName',
      width: '5%'
    },
    {
      title: '执行人',
      dataIndex: 'executor',
      key: 'executor',
      width: '5%'
    },
    {
      title: '执行人电话',
      dataIndex: 'telep',
      key: 'telep',
      width: '5%'
    },
    {
      title: '状态',
      dataIndex: 'status',
      key: 'status',
      width: '5%',
      render:text=>taskStatusEnum[text]
    },
    {
      title: '到期时间',
      dataIndex: 'finishTime',
      key: 'finishTime',
      width: '6%',
      render: text => renderLongTime(text)
    },
    {
      title: '完成时间',
      dataIndex: 'factFinishTime',
      key: 'factFinishTime',
      width: '6%',
      render: text => renderLongTime(text)
    },
    {
      title: '任务内容',
      dataIndex: 'remark',
      key: 'remark',
      width: '15%'
    }
  ];
};
//偏移110px
const offsetHeight = 110;
const defaultHeight = 450;
/**
 *巡检点列表页面
 *
 * @class PointListView
 * @extends {Component}
 */
class TaskListView extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: props.outterPageConfig ? props.outterPageConfig.current : 1,
      pageSize: props.outterPageConfig ? props.outterPageConfig.pageSize : 10
    };
    this.state = {
      searchParam: {},
      dataList: [],
      totalCount: 0,
      selectedRows: [],
      selectedRowKeys: [],
      reload() {}
    };
  }

  componentWillMount() {
    if (this.props.point) {
      let { searchParam } = this.state;
      searchParam['pointId'] = this.props.point.id;
      this.setState({searchParam});
    }
  }
    componentWillReceiveProps(nextProps) {
    if (nextProps.point) {
      let { searchParam } = this.state;
      if(nextProps.flag === 'forword'){
        searchParam['pointId'] = nextProps.point.id;
        this.setSearchParam(searchParam);
      }
    }
  }

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  }

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  }

  setSearchParam = searchParam => {
    this.setState({ searchParam });
    this.getTaskListData(searchParam);
  }

  getTaskListData = param => {
    let { searchParam } = this.state;

    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    Object.assign(searchParam, { ...param });
    fetchTaskListAction(searchParam).then(data => {
      this.setState({
        dataList: data.content,
        totalCount: data.totalElements
      });
    });
  }

  getRowClassName = (record, index) => {
    let highlight = this.highlight;
    if (highlight && record.id === highlight) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  }

  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.current = current;
    }
  }

  getPanelHeight = () => {
    let alarmTablePanel = this.alarmTablePanel;
    let tableLocation = dt2react.getOffset(alarmTablePanel) || {};
    return tableLocation  !== undefined ? tableLocation.height - offsetHeight : defaultHeight;
  }

  render() {
    let { dataList, totalCount, searchParam } = this.state;
    return (
      <div className="create-device-root">
        <div className="create-device-host-top">
          <div className="table-title">任务信息列表</div>
          <div className="table-search">
            <TaskSearch setSearchParam={this.setSearchParam} searchParam={searchParam || {}} point={this.props.point}/>
          </div>
        </div>
        <div className="create-device-host-bottom">
          <div className="device-list-content" >
            <AmosGridTable
              columns={taskListColumns()}
              callBack={this.reload}
              dataList={dataList}
              totals={totalCount}
              getTableDataAction={this.getTaskListData}
              getSelectedRows={this.getSelectedRows}
              rowClassName={this.getRowClassName}
              setPageConfig={this.setPageConfig}
              defaultPageConlHeight={this.getPanelHeight}
              isChecked={false}
              onRowClick={this.onRowClick}
            />
          </div>
        </div>
      </div>
    );
  }
}

TaskListView.propTypes = {};

export default TaskListView;
