import React from 'react';
import PropTypes from 'prop-types';

const noop = () => void 0;

const Logo = props => {
  const { icon, min, text, minIcon, onClick = noop } = props;
  if (min){
    return (
      <div className="logo-wrapper" onClick={onClick}>
        <img src={minIcon} alt="" />
      </div>
    );
  }
  return (
    <div className="logo-wrapper" onClick={onClick}>
      <img src={icon} alt="" />
      <div className="logo-text">{text}</div>
    </div>
  );
};

Logo.propTypes = {
  icon: PropTypes.string,
  min: PropTypes.bool,
  text: PropTypes.string,
  minIcon: PropTypes.string,
  onClick: PropTypes.func
};

export default Logo;
