import React, { Component } from 'react';
import PropTypes from 'prop-types';
import {connect} from "react-redux";
import RayMediaquery from 'ray-mediaquery';
import Logo from './Logo';
import MenuList from './MenuList';
import ExtraTools from './ExtraTools';

/**
 * 通用header
 *
 * @class Header
 * @extends {Component}
 */
class Header extends Component {

  constructor(props) {
    super(props);
    this.state = {
      activeHeight: 0,
      showText: true,
      is3dview: true
    };
    this.expanded = false;
  }

  componentDidMount() {
    RayMediaquery.register('only screen and (min-width: 0) and (max-width: 992px)', {
      match: () => {
        this.setState({ showText: false });
      },
      unmatch: () => {
        this.setState({ showText: true });
      }
    });
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps.routing.locationBeforeTransitions.pathname.indexOf('3dview')>0) {
      if (!this.state.is3dview) {
        this.setState({
          is3dview: true
        })
        this.props.is3dviewChange(true)
      }
    } else {
      if (this.state.is3dview) {
        this.setState({
          is3dview: false
        })
        this.props.is3dviewChange(false)
      }
    }
  }

  onMouseOver = () => {
    // 未打开
    if (!this.expanded){
      this.expanded = true;
      this.toggleSubMenu(this.expanded);
    }
  }

  onMouseOut = () => {
    if (this.expanded){
      this.expanded = false;
      this.toggleSubMenu(this.expanded);
    }
  }

  toggleSubMenu = (flag) => {
    const { height } = this.props;
    const activeHeight = flag ? height : 0;
    this.setState({
      activeHeight
    });
  }

  render() {
    const { activeHeight, showText, is3dview } = this.state;
    const { navs } = this.props;
    let leftNavs = navs.slice(0,3)||[];
    let rightNavs = navs.slice(3,6)||[];

    if (is3dview) {
      return (
        <div className="headerIndex header">
          <div className="header-navs leftNavs">
            <MenuList
              {...this.props}
              height={activeHeight}
              showText={showText}
              toggleSubMenu={this.toggleSubMenu}
              onMenuOpen={this.onMouseOver}
              onMenuClosed={this.onMouseOut}
              navs={leftNavs}
              key='1'
            />
          </div>
          <div className='projectName'>
            {/* {this.props.logoText} */}
            <img src='/src/assets/3dview/headerTitle.png' />
          </div>
          <div className="header-navs rightNavs">
            <MenuList
              {...this.props}
              height={activeHeight}
              showText={showText}
              toggleSubMenu={this.toggleSubMenu}
              // onMenuOpen={this.onMouseOver}
              onMenuClosed={this.onMouseOut}
              navs={rightNavs}
              key='2'
            />
          </div>
        </div>
      );
    } else {
      return (
        <div className="header">
          <div className="header-navs">
            <Logo {...this.props} showText={showText} />
            <MenuList
              {...this.props}
              height={activeHeight}
              showText={showText}
              toggleSubMenu={this.toggleSubMenu}
              onMenuOpen={this.onMouseOver}
              onMenuClosed={this.onMouseOut}
            />
            <ExtraTools {...this.props} showText={showText} />
          </div>
        </div>
      );
    }

  }
}

Header.defaultProps = {
  height: 310
};

Header.propTypes = {
  height: PropTypes.number
};
const headerState = (state) => {
  return {
    routing: state.routing
  }
}

export default connect(headerState)(Header);
