import React, { Component } from 'react';
import PropTypes from 'prop-types';

/**
 * logo 组件，支持扩展额外按钮功能
 * @class Logo
 * @extends {Component}
 */
class Logo extends Component {
  render() {
    const { logoImg, onLogoClick } = this.props;
    return (
      <div className="logo-wrapper">
        <div className="header-logo" onClick={onLogoClick}>
          {/* <img className="header-logo-pic" src={logoImg} alt="" /> */}
          <div className="logo-text">安全预控执行系统</div>
        </div>
      </div>
    );
  }
}

Logo.propTypes = {
  logoImg: PropTypes.string,
  onLogoClick: PropTypes.func,
  logoExtra: PropTypes.oneOfType([
    PropTypes.node,
    PropTypes.bool
  ])
};

export default Logo;
