import { Icon } from 'amos-framework';
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import  '../../../styles/view/component/drawer.scss';


/**
 * 查询侧边栏
 *
 * @class SideQueryLyout
 * @extends {Component}
 */
class SideQueryLyout extends Component{
  constructor(props) {
    super(props);
    this.state = {
      content: {
        right: '-250px',
        opacity: 'block'
      },
      client: {
        right: '0px',
        opacity: 'show',
        display: 'block'
      }
    };
  }

  componentWillMount = () => {
    if (void 0 !== this.props.open) {
      if (this.props.open) {
        this.openSide();
      } else {
        this.colseSide();
      }
    } else {
      this.colseSide();
    }
  }

  componentWillReceiveProps = (nextProps) => {
    if (void 0 !== nextProps.open) {
      if (nextProps.open) {
        this.openSide();
      } else {
        this.colseSide();
      }
    } else {
      this.changeStatus();
    }
  }

  openSide = () => {
    const { open } = this.state;
    let ClientContent = {
      right: '0px',
      display: 'block',
      height: '100%'
    };
    let newClient = {
      right: '300px',
      display: 'none'
    };
    if (void 0 !== open && open !== true) {
      this.props.callback(!open);
    }
    this.setState({ content: ClientContent, client: newClient, open: true });
  }

  colseSide = () => {
    const { open } = this.state;
    let ClientContent = {
      right: '-250px',
      opacity: 'block'
    };
    let newClient = {
      right: '0px',
      opacity: 'show',
      display: 'block'
    };
    if (void 0 !== open && open !== false) {
      this.props.callback(!open);
    }
    this.setState({ content: ClientContent, client: newClient, open: false });
  }

  changeStatus = (e) => {
    const { content, open } = this.state;
    if (content.right !== '0px') {
      this.openSide();
    } else {
      this.colseSide();
    }
    if (this.props.callback) {
      this.props.callback(!open);
    }
  }

  render() {
    const { content, client } = this.state;
    return (
      <div className="qq-client-body">
        <div style={client} className="qq-client">
        </div>
        <div className="qq-client-content" style={content}>
          <h2>
            查询条件
            <a className="qq-client-open" onClick={this.changeStatus} >
              <Icon size="1x"  prefix="amosicon" icon="gengduo2" />
            </a>
          </h2>
          <div className="qq-client-open-content">
            {this.props.children}
          </div>
        </div>
      </div>
    );
  }
}

SideQueryLyout.propTypes = {
  children: PropTypes.node,
  open: PropTypes.bool,
  callback: PropTypes.func
};

export default SideQueryLyout;
