import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Radio, Select, DatePicker, Input } from 'amos-antd';

const Option = Select.Option;
const RadioButton = Radio.Button;
const RadioGroup = Radio.Group;

/**
 * 单属性筛选
 * @class PropsFilter
 * @extends {Component}
 */
class PropsFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      filterValue: ''
    };
    this.textChange = this.textChange.bind(this);
    this.radioChange = this.radioChange.bind(this);
    this.selectChange = this.selectChange.bind(this);
  }

  textChange(e){
    this.props.changeFilters(this.props.dataIndex,e.target.value);
  }

  radioChange(e){
    this.props.changeFilters(this.props.dataIndex,e.target.value);
  }

  selectChange(value){
    this.props.changeFilters(this.props.dataIndex,value);
  }

  dateChange = (value) => {
    this.props.changeFilters(this.props.dataIndex,value);
  }

  selectTypeFilter = () => {
    const { st } = this.props;
    switch (st)
    {
      case 'text':
        return this.textContent();
      case 'list':
        return this.listContent();
      case 'date':
        return this.dateContent();
      case 'redio':
        return this.redioContent();
    }
  }

  textContent = () => {
    return (
      <Input id='filterValue' className='amos-filter-text' onChange={this.textChange} name='filterValue' />
    );
  }

  dateContent = () => {
    return (
      <DatePicker className='amos-filter-date'  onChange={this.dateChange} name='filterValue' id='filterValue' />
    );
  }

  listContent = () => {
    let { list } = this.props;
    return (
      <Select  showSearch optionFilterProp="children" onChange={this.selectChange} defaultValue='全部'  className='amos-filter-list'  >
        <Option key='all' value='全部'>全部</Option>
        {
          list.map(e=>(
            <Option key={e} value={e}>{e}</Option>
          ))
        }
      </Select>
    );
  }

  redioContent = () => {
    let { list } = this.props;
    return (
      <RadioGroup onChange={this.radioChange} defaultValue='全部'  className='amos-filter-redio' >
        <RadioButton value='全部'>全部</RadioButton>
        {
          list.map(e=>(
            <RadioButton key={e} value={e}>{e}</RadioButton>
          ))
        }
      </RadioGroup>
    );
  }

  render() {
    let { title } = this.props;
    return (
      <li className='amos-table-filter-li'>
        <span className='amos-prop-filter'>{title}</span>
        <span className='amos-filter-value'>
          {this.selectTypeFilter()}
        </span>
      </li>
    );
  }
}

PropsFilter.propTypes = {
  title: PropTypes.string,
  st: PropTypes.string,
  list: PropTypes.array,
  changeFilters: PropTypes.func,
  dataIndex: PropTypes.string
};

PropsFilter.defaultProps = {
  list: [],
  allFilter: []
};

export default PropsFilter;
