import { Dropdown, Button, DropNav, Icon, Menu } from 'amos-framework';
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import '../../../styles/view/component/toolbar.scss';
import BizIcon from './../../common/icon/BizIcon';
/**
 * 工具栏
 *
 * @class ToolBar
 * @extends {Component}
 */
class ToolBar extends Component{
  constructor(props) {
    super(props);
    this.state = {
      navs: [],
      isWriteable: false
    };
  }

  componentWillMount() {
    const { dropnavs } = this.props;
    this.setState({ navs: dropnavs });
  }

  getButton = (record) => {
    return (<Button onClick={(e) => this.handlerOnClick(record, e)} transparent value={record.key} icon={<BizIcon icon={record.icon} />} >{record.text}</Button>);
  }

  getNavMenu = (record) => {
    if (record.subSys.length > 0 && record.subSys[0].href.startsWith('jacascript::void(0)')) {
      return (
        <Dropdown
          customContent={this.renderMenu(record.subSys)}
          onSelect={this.handlerOnClick}
          className='check-drop-down'
        >
          <div><BizIcon icon={record.icon} />{record.text}</div>
        </Dropdown>);
    } else {
      return (
        <Dropdown
          menus={record.subSys}
          className='check-drop-down'
        >
          <Button onClick={(e) => this.handlerOnClick(record, e)} transparent value={record.key} icon={<BizIcon icon={record.icon} />} >{record.text}</Button>
        </Dropdown>);
    }
  }

  getMenuItems = (subSys) => {
    let { callBack } = this.props;
    let items = new Array();
    for ( let i = 0; i < subSys.length; i++) {
      let sub = subSys[i];
      items.push(<Menu.Item onClick={() => callBack(sub.key)}>{sub.text}</Menu.Item>);
    }
    return items;
  }

  getDropnav = (record) => {
    let arr = new Array();
    arr.push(record);
    return (<DropNav  navs={arr} theme="light" />);
  }

  handlerOnClick = (navItem, e) =>{
    let { callBack } = this.props;
    if (!navItem.href.startsWith('jacascript::void(0)')) {
      return true;
    }
    callBack(navItem.key);
    return false;
  }

  renderMenu = (subSys) => {
    return (
      <Menu>
        {this.getMenuItems(subSys)}
      </Menu>
    );
  }

  render() {
    const { navs } = this.state;
    const { style = {} } =  this.props;
    let context = navs.map( item => {
      if (item.subSys) {
        return this.getNavMenu(item);
      } else if (!item.href.startsWith('jacascript::void(0)')) {
        return this.getDropnav(item);
      } else {
        return this.getButton(item);
      }
    });
    return (
      <div className='check-tool-root patrol-page-table-tool' style={style}>
        {context}
      </div>
    );
  }
}

ToolBar.propTypes = {
  callBack: PropTypes.func,
  dropnavs: PropTypes.array,
  style: PropTypes.object
};

export default ToolBar;
