import React, { Component } from 'react';
import PropTypes from 'prop-types';
import * as endConf from 'amos-processor/lib/config/endconf';
import './plugins/adapter';
import { H5sEvent } from './plugins/h5sevent';
import { H5sPlayerWS,H5sPlayerHls,H5sPlayerRTC } from './plugins/h5splayer';
import { H5siOS,H5sPlayerCreate } from './plugins/h5splayerhelper';
import './index.scss';

const AmosConfig = endConf.AmosConfig;

class LiverPlay extends Component {
  constructor(props) {
    super(props);
    this.fullscreen = false;
  }

  componentDidMount() {
    this.playVedio();
  }

  componentWillUnmount() {
    this.disConnect();
  }

  disConnect = () => {
    console.log('-------------------->', this.props.vedioId);
    this.h5handler && this.h5handler.disconnect && this.h5handler.disconnect();
  }

  playVedio = () => {
    const { token, vedioId, noMax } = this.props;
    if (vedioId && token && !this.h5handler) {
      // const dom = document.getElementById(vedioId);
      console.log('===================>',vedioId, token);
      const conf = {
        videoid: vedioId,
        protocol: 'http:', //http: or https:
        host: AmosConfig.httpURI.liveVideoHost, //localhost:8080
        streamprofile: undefined, // {string} - stream profile, main/sub or other predefine transcoding profile
        rootpath: '/',
        token: token,
        hlsver: 'v1',
        session: null
      };

      this.h5handler = new H5sPlayerWS(conf);
      this.h5handler.connect();
    }
  }
//   <div className="liver-play-bars">
//   <a className="liver-play-bars-item" onClick={noMax ? this.onFullScreen}><img src="/src/assets/audio/toMax.png" alt="" /></a>
// </div>
  render() {
    const { vedioId, token, width, height } = this.props;
    if (token && vedioId) {
      return (
        <div className="liver-play-wrapper" style={{ width, height }} ref={node => this.wrapper = node}>
          <video  width="100%" height="100%" id={vedioId} autoplay webkit-playsinline playsinline>
            Your browser does not support the video tag.
          </video>

        </div>
      );
    } else {
      return (
        <div className="liver-play-wrapper" style={{ width, height }} ref={node => this.wrapper = node} >
          <div />
        </div>
      );
    }
  }
}

LiverPlay.propTypes = {
  onFullScreen: PropTypes.func
};

LiverPlay.defaultProps = {
  onFullScreen(){}
};
export default LiverPlay;
