import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { browserHistory } from 'amos-react-router';
import { LocationParam, utils } from 'amos-tool';
import { getBizMenusAction } from '../../services/securityService';
import Header from '../common/header';
import BusinessStorage from '../bizview';
/**
 * 内嵌 控制台 视图
 *
 * @class SubConsoleView
 * @extends {Component}
 */
class SubConsoleView extends Component {

  constructor(props) {
    super(props);
    this.state = {
      menus: []
    };
  }

  componentDidMount() {
    this.initMenus();
  }

  onOpenDefaultPage = (menus) => {
    // open first url
    if (location.pathname === '/console/config'){
      const item = menus.filter(e => e.url)[0] || {};
      if (!utils.isEmpty(item)){
        if (item.url){
          browserHistory.push(item.url);
        }
      }
    }
  }

  initMenus = () => {
    const lps = LocationParam.getLocationParams();
    const code = lps.rootnav;
    getBizMenusAction(code).then(d => {
      this.setState({
        menus: d
      }, () => {
        this.onOpenDefaultPage(d);
      });
    });
  }

  handleMenuClick = () => {

  }

  render() {
    const { menus } = this.state;
    const { children } = this.props;
    const style = {
      width: '100%',
      height: '100%'
    };
    return (
      <div style={style}>
        <BusinessStorage />
        <Header onlyNav menus={menus} onMenuItemClick={this.handleMenuClick} />
        <div style={style}>{children}</div>
      </div>
    );
  }
}

SubConsoleView.propTypes = {
  children: PropTypes.node
};

export default SubConsoleView;
