import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Checkbox } from 'amos-framework';
import { controlImg } from './_markerConsts';

const EvolutionGroup = Checkbox.EvolutionGroup;

const resourceCtls = [
  { key: 'equip', icon: 'equip', tip: '设备信息' },
  { key: 'risk', icon: 'risk', tip: '风险点' },
  { key: 'video', icon: 'video', tip: '监控设备' }
];

/**
 * 业务控制区
 *
 * @class BizControlPane
 * @extends {Component}
 */
class BizControlPane extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selects: ''
    };
  }

  onChange = (selects, item) => {
    this.setState({
      selects
    });
    const checked = !!selects;
    this.props.onItemClick && this.props.onItemClick(item, checked);
  }

  renderItem(item = {}){
    const { key, icon, className, onClick, tip } = item;
    return (
      <div key={key} className={className} onClick={onClick} title={tip}>
        <img className="ctl-item-img" src={controlImg[icon]} alt="" />
      </div>
    );
  }

  render() {
    const { selects } = this.state;
    return (
      <EvolutionGroup
        single
        vertical
        selects={selects}
        datas={resourceCtls}
        onChange={this.onChange}
        renderItem={this.renderItem}
      />
    );
  }
}

BizControlPane.propTypes = {
  subscribe: PropTypes.func,
  onItemClick: PropTypes.func,
  handleDesignClick: PropTypes.func
};

export default BizControlPane;
