import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect } from 'amos-framework';
// import AmosWebSocket from 'amos-websocket';
import TileControl from './TileControl';
import DataPane from './datapane/index';
import Plan from './plan/index';
import { rulesDataFactory, eventTopics, globalMsg } from './consts';
// import SysWsURL, { completeToken } from './../../consts/wsUrlConsts';

const eventConnect = Connect.eventConnect;

/**
 * 页面内容区域（非瓦片）
 *
 * @class TileContent
 * @extends {Component}
 */
@eventConnect
class TileContent extends Component {
  constructor(props) {
    super(props);
    this.state = {
      planStarted: true,
      alarmStarted: false
    };
  }

  componentDidMount() {
    console.log('TileContent~~~~~~~~~~~~~~~~');
    this._bindRulePubSubEvents();
  }

  _bindRulePubSubEvents = () => {
    this.props.subscribe(eventTopics.alarm_confirm_msg, (topic, data) => {
      this.planStart();
    });
    this.props.subscribe(eventTopics.plan_end, (topic, data) => {
      this.planQuit();
    });
  }

  planStart = data => {
    this.setState(
      {
        planStarted: true,
        alarmStarted: true
      },
      () => {
        this.props.trigger(eventTopics.plan_start, {
          planStarted: this.state.planStarted,
          alarmStarted: this.state.alarmStarted
        });
      }
    );
  };

  planQuit = () => {
    this.props.trigger(eventTopics.plan_start, { planStarted: false });
    this.setState({ planStarted: false, alarmStarted: false });
  };

  alarmStart = () => {
    this.setState({
      alarmStarted: true
    });
  };

  /**
   * 监控视图消息 (规则 ws)
   */
  handleData = data => {
    console.log('rule ws data:', data);
    const { topic, content } = rulesDataFactory(data);
    if (topic === eventTopics.global_msg) {
      globalMsg(content);
      return;
    }
    this.props.trigger(topic, content);
  };

  render() {
    const { onItemClick } = this.props;
    const { planStarted, alarmStarted } = this.state;
    // const wsURL = SysWsURL.viewTileURI;
    const controlAnimation = {
      animateName: 'zoom-comb-left',
      visible: !alarmStarted,
      animateProps: {
        key: 'animate-sidecontrol', // animate key
        transitionAppear: true
      }
    };
    const datapaneAnim = {
      animateName: 'zoom-comb-right',
      visible: !alarmStarted,
      animateProps: {
        key: 'animate-datapane', // animate key
        transitionAppear: true
      }
    };
    const layerPoolAnimation = {
      animateName: 'fade',
      visible: planStarted,
      // 设置动画延迟 5 秒
      animateDelay: 0,
      animateProps: {
        key: 'animate-layerPool', // animate key
        transitionAppear: true
      }
    };
    return (
      <div>
        {/*<AmosWebSocket ref={node => this.aws = node} url={wsURL} onMessage={this.handleData} reconnect debug />*/}
        <TileControl onItemClick={onItemClick} animationProps={controlAnimation} />
        <DataPane animationProps={datapaneAnim} />
        <Plan animationProps={layerPoolAnimation} alarmStart={this.alarmStart} planStart={this.planStart} planQuit={this.planQuit} planStarted={planStarted} />
      </div>
    );
  }
}

TileContent.propTypes = {
  onItemClick: PropTypes.func,
  trigger: PropTypes.func,
  subscribe: PropTypes.func
};

export default TileContent;
