import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { SidePane } from 'amos-framework';
import BizControlPane from './BizControlPane';
import InnateControlPane from './InnateControlPane';

class TileControl extends Component {
  constructor(props) {
    super(props);

  }

  render() {
    const { onItemClick, animationProps } = this.props;
    return (
      <SidePane className="tile-sidepane-control" left={10} right={false} top={140} {...animationProps}>
        <BizControlPane onItemClick={onItemClick} />
        <InnateControlPane onItemClick={onItemClick} />
      </SidePane>
    );
  }
}

TileControl.propTypes = {
  onItemClick: PropTypes.func,
  animationProps: PropTypes.any
};

export default TileControl;
