import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Animate, Connect } from 'amos-framework';
import imgStatic from './../../../consts/imgStatic';
import getContent from './getContent';
import DrawerContent from './DrawerContent';
import BizIcon from '../../common/icon/BizIcon';
import { eventTopics } from './../consts';

const AnimateAddonBox = Animate.AnimateAddonBox;
const eventConnect = Connect.eventConnect;

/**
 * 右侧 drawer
 *
 * @class Drawer
 * @extends {Component}
 */
@eventConnect
class Drawer extends Component {

  constructor(props) {
    super(props);
    this.state = {
      activeBar: {},
      activeKey: '',
      content: null,
      expanded: false,
      // 数据列表状态，用于展示小红点
      dataStutas: {
        msg: true
      },
      showLabel: {
        search: false,
        msg: false,
        record: false,
        broadcast: false,
        setting: false
      } // 是否显示提示
    };
  }

  componentDidMount = () => {
    this.props.subscribe(eventTopics.viewTile_init, (topic, data) => {
      this.closeDrawer();
    });
  }

  onBarItemClick = (item) => {
    const { dataStutas } = this.state;
    dataStutas[item.key] = false;
    this.setState({
      expanded: true,
      activeBar: item,
      content: getContent(item.key),
      dataStutas
    });
  }

  closeDrawer = () => {
    this.setState({
      expanded: false,
      activeBar: {}
    });
  }

  changeLabelState(e, type, key) {
    let { showLabel } = this.state;
    if (type === 'over') {// mouse over
      showLabel[key] = true;
      this.setState({ showLabel });
    } else if (type === 'out') {// mouse out
      showLabel[key] = false;
      this.setState({ showLabel });
    }
  }

  renderDrawerBar = () => {
    const { activeBar, dataStutas, showLabel } = this.state;
    const { barList } = this.props;
    return (
      <ul className="drawer-bar-list">
        {
          barList.map(bl => {
            //const imgPath = imgStatic.datapane[bl.icon];
            const cls = activeBar && activeBar.key === bl.key ? 'drawer-bar-item drawer-bar-item-active' : 'drawer-bar-item';
            const showDot = dataStutas[bl.key];
            return (
              bl.disabled ? <li key={bl.key} className={cls} style={{ cursor: 'not-allowed' }} >
                {showDot && <span className="bar-status-dot" />}
                <div className="bar-info" title={bl.label}>
                  <BizIcon icon={bl.icon} />
                </div>
              </li>
              : <li key={bl.key} className={cls} onClick={() => this.onBarItemClick(bl)} onMouseOver={(e) => this.changeLabelState(e, 'over', bl.key)} onMouseOut={(e) => this.changeLabelState(e, 'out', bl.key)} >
                {showDot && <span className="bar-status-dot" />}
                <div className="bar-info" title={bl.label}>
                  <BizIcon icon={bl.icon} />
                  {/**<div className="marker-icon-title" style={{ visibility: showLabel[bl.key] ? 'inherit' : 'hidden' }}>
                    <div className="title-text">{bl.label}</div>
                    </div>*/}
                </div>
              </li>
            );
          })
        }
      </ul>
    );
  }

  render() {
    const { content: DrawerComponent, activeBar, expanded } = this.state;
    return (
      <Animate key="drawer-panel" transitionName="slide-right" showProp="toggle" transitionLeave={false}>
        <AnimateAddonBox toggle={expanded}>
          <div className="datapane-drawer">
            <div className="drawer-bar">
              <div className="bar-top" />
              {this.renderDrawerBar()}
              <div className="bar-bottom" />
            </div>
            {
              expanded &&
              <DrawerContent
                onClose={this.closeDrawer}
                header={activeBar.title}
                body={<DrawerComponent />}
              />
            }
          </div>
        </AnimateAddonBox>
      </Animate>
    );
  }
}

Drawer.propTypes = {
  barList: PropTypes.arrayOf(PropTypes.shape({
    key: PropTypes.string,
    icon: PropTypes.string,
    label: PropTypes.string,
    title: PropTypes.string
  })),
  subscribe: PropTypes.func
};

export default Drawer;
