import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';

class DrawerContent extends Component {
  render() {
    const { header, onClose, body } = this.props;
    return (
      <div className="drawer-content">
        <div className="drawer-content-header">
          <div className="drawer-content-header-title">
            <span>{header}</span>
          </div>
          <div className="drawer-content-header-close" onClick={onClose}>
            <Icon icon="close" />
          </div>
        </div>
        <div className="drawer-content-body">{body}</div>
      </div>
    );
  }
}

DrawerContent.propTypes = {
  header: PropTypes.string,
  onClose: PropTypes.func,
  body: PropTypes.node
};

export default DrawerContent;
