import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { SidePane } from 'amos-framework';
import Drawer from './Drawer';

const dataPanes = [
  { key: 'search', icon: 'sousuo', label: '检索', title: '信息检索',disabled: false },
  { key: 'msg', icon: 'xiaoxi', label: '消息', title: '消息提醒',disabled: false },
  { key: 'setting', icon: 'shezhi', label: '设置', title: '系统设置' ,disabled: false }
];

class DataPane extends Component {
  render() {
    const { animationProps } = this.props;
    return (
      <SidePane className="side-pane-data" left={false} right={0} top={40} {...animationProps}>
        <Drawer barList={dataPanes} />
      </SidePane>
    );
  }
}

DataPane.propTypes = {
  animationProps: PropTypes.any
};

export default DataPane;
