import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, SidePane } from 'amos-framework';
import AmosWebSocket from 'amos-websocket';
import * as endConf from 'amos-processor/lib/config/endconf';
import ReservePlan from './buttom/index';
import PlanDetail from './right/PlanDetail';
import RecordView from './left/records/RecordView';
import StepView from './left/steps/StepView';
import TopView from './left/topNews/TopView';
import MonitorView from './left/monitor/MonitorView';
import Water from './left/water/Water';
import { eventTopics } from './../consts';
import TopMsg from './top/TopMsg';

const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;

const sidepaneStyles = {
  topArea: {
    left: '50%',
    top: 0,
    transform: 'translateX(-50%)'
  },
  operatePos: {
    left: '50%',
    bottom: 30,
    transform: 'translateX(-50%)',
    zIndex: 10
  }
};

/**
 * 预案加载
 *
 * @class Plan
 * @extends {Component}
 */
@eventConnect
class Plan extends Component {
  constructor(props) {
    super(props);
    this.state = {
      displayDetail: true,
      stepMonitorAreaShow: false,
      fireResourceData: null,
      detailPos: {
        right: 20,
        top: 21,
        planStartTop: 46,
        bottom: 154
      },
      recordPos: {
        left: 21,
        bottom: 33
      },
      setupPos: {
        left: 21,
        top: 21
      },
      monitorPos: {
        left: 21,
        top: 236
      },
      waterPos: {
        left: 21,
        top: 310
      }
    };
  }

  componentDidMount() {
    console.log('Plan~~~~~~~~~~~~');
    this.screenChange();
    this._bindPubSubEvents();
  }

  componentWillReceiveProps(nextProps) {
    this.setState({ planStarted: nextProps.planStarted });
  }

  onCancal = () => {
    this.setState({ displayDetail: false });
  };

  _bindPubSubEvents = () => {
    this.props.subscribe(eventTopics.plan_detail, (topic, content) => {
      this.setState({ displayDetail: true });
    });
  };

  screenChange = () => {
    window.addEventListener('resize', this.resize);
  };

  handleData = data => {
    this.setState({ fireResourceData: data });
  }

  resize = () => {};

  render() {
    const { detailPos, recordPos, setupPos, monitorPos, waterPos, displayDetail, planStarted, fireResourceData } = this.state;
    const { animationProps, planStart, planQuit, alarmStart } = this.props;
    let detailTop = planStarted ? detailPos.top : detailPos.planStartTop;
    // let wsURL = AmosConfig.wsURI.securityBaseURI + 'plan';
    return (
      <div className="layer-pool">
        <TopMsg alarmStart={alarmStart} />
        <SidePane
          className={displayDetail ? 'precontrol-sidePlan-detail-display' : 'precontrol-sidePlan-detail'}
          left={false}
          right={detailPos.right}
          top={detailTop}
          bottom={detailPos.bottom}
          {...animationProps}
        >
          <PlanDetail cancal={this.onCancal} />
        </SidePane>
        <SidePane className='record-view' top={false} left={recordPos.left} bottom={recordPos.bottom} {...animationProps}>
          <RecordView />
        </SidePane>
        <SidePane left={setupPos.left} top={setupPos.top} {...animationProps}>
          <StepView />
        </SidePane>
        <SidePane className='monitor-view' left={monitorPos.left} top={monitorPos.top} {...animationProps}>
          <MonitorView planStart={planStart} />
        </SidePane>
        {/*
        <SidePane className='monitor-view' left={waterPos.left} top={waterPos.top} {...animationProps}>
          <Water planStart={planStart} fireResourceData={fireResourceData} />
        </SidePane>
        */}
        <SidePane top={false} left={false} style={sidepaneStyles.operatePos} {...animationProps}>
          <ReservePlan />
        </SidePane>
        <SidePane className="rule-pool-topview" top={false} left={false} style={sidepaneStyles.topArea}>
          <TopView planStart={planStart} planQuit={planQuit} planStarted={planStarted} />
        </SidePane>
      </div>
    );
  }
}
Plan.propTypes = {
  planStart: PropTypes.func,
  animationProps: PropTypes.any,
  subscribe: PropTypes.func,
  planQuit: PropTypes.func,
  alarmStart: PropTypes.func,
  planStarted: PropTypes.bool
};
export default Plan;
