import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';
import { broadcastAction } from 'SERVICES/3dService';
import { Connect, Timeline } from 'amos-framework';
import { eventTopics } from './../../../consts';

const eventConnect = Connect.eventConnect;
const Item = Timeline.Item;
const recordType = 'MESSAGE';

const fakeData = [{ recordType: 'MESSAGE', createDate: '20191119', content: '压缩机机组超速提示已发送' }];

@eventConnect
class RecordView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showContent: true,
      data: []
    };
  }

  componentDidMount() {
    console.log('RecordView~~~~~');
    this.props.subscribe(eventTopics.record_view, (topic, data) => {
      if (topic === eventTopics.record_view) {
        this.onHandleMsg(data.batchNo);
      }
    });
  }

  onHandleMsg = batchNo => {
    this.getPlanExeRecord(batchNo);
  };

  /**
   * 查询预案执行明细
   * @memberof Broadcast
   */
  getPlanExeRecord = batchNo => {
    batchNo && this.refshTimeLine(batchNo);
  };

  refshTimeLine = batchNo => {
    broadcastAction(batchNo,recordType).then(data => {
      const { showContent } = this.state;
      showContent ? '' : this.setState({ showContent: true }); //显示执行明细
      this.setState({ data });
    });
  };

  renderItem = data => {
    return data.map(item => {
      if (item.recordType === 'MESSAGE') {
        return (
          <Item>
            <span>{item.createDate ? moment(item.createDate).format('YYYY/MM/DD HH:mm:ss') : ''}</span>
            <p >{item.content}</p>
          </Item>
        );
      }
    });
  };

  render() {
    let { showContent, data } = this.state;
    return showContent ? (
      <div className='record-view-parent'>
        <div className="precontrol-record-view">
          <Timeline>
            {this.renderItem(data)}
          </Timeline>
        </div>
      </div>
    ) : '';
  }
}

RecordView.propTypes = {
  subscribe: PropTypes.func
};

export default RecordView;
