import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Timeline } from 'amos-framework';
import { eventTopics } from './../../../consts';
import { DESIGNER_CONSTS } from 'amos-3d/lib/designer';

const eventConnect = Connect.eventConnect;
const Item = Timeline.Item;

@eventConnect
class StepView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      stepName: '',
      nextStepName: '',
      showContent: 'none'
    };
  }

  componentDidMount() {
    console.log('StepView~~~~~~');
    this.props.subscribe(eventTopics.stepArea_view, (topic, content) => {
      const { data } = content;
      const { stepName, nextStepName } = data;
      this.setState({ stepName, nextStepName, showContent: 'block' });
    });
  }

  render() {
    let { stepName, nextStepName } = this.state;
    let planEnd = stepName && !nextStepName;
    return (
      <div className="precontrol-step-view" style={{ display: this.state.showContent }} >
        { !planEnd ?
          (
            <div style={{ height: '100%' }}>
              <Item />
              <Item className="previous-step" dot={<img src={require('./../../../../../assets/tileview/prePlan/buzhouqu-dangqianbu.png')} alt="" />}><p>{stepName}</p></Item>
              <Item className="next-step" dot={<img src={require('./../../../../../assets/tileview/prePlan/buzhouqu-xiayibu.png')} alt="" />} >{nextStepName}</Item>
            </div>
          )
          :
          (
            <div style={{ height: '100%' }}>
              <Item />
              <Item className="previous-step" dot={<img src={require('./../../../../../assets/tileview/prePlan/buzhouqu-dangqianbu.png')} alt="" />}><p>{stepName}</p></Item>
            </div>
          )
        }
      </div>
    );
  }
}

StepView.propTypes = {
  subscribe: PropTypes.func
};

export default StepView;
