import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col } from 'amos-framework';
import moment from 'moment';
import SymIcon from './../../../common/icon/SymIcon';
import Video from './Video';
import DetailCard from './DetailCard';
import imgStatic from './../../../../consts/imgStatic';

const pointIcon = imgStatic.planDetail;

class EquipDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {},
      type: ''
    };
  }

  componentWillMount = () => {
    this.setState({ equip: this.props.equip, type: this.props.type });
  }

  componentWillReceiveProps = nextProps => {
    this.setState({ equip: nextProps.equip, type: nextProps.type });
  }

  getIcon = (type) => {
    if (type === 'video') {
      return (<img src={pointIcon.video} alt="" />);
    } else {
      return (<SymIcon icon="ziyuanliebiao" style={{ width: '59px', height: '46px' }} />);
    }
  }

  render() {
    const { equip = {},type } = this.state;
    let position = '';
    if (Object.keys(equip).length > 0 ){
      position = equip.productionArea ? equip.productionArea : position;
      position = equip.floor3d ? position + '-' + equip.floor3d + '层' : position;
      position = equip.room ? position + '-' + equip.room : position;
      let begin = position.indexOf('-') >= 0 ? position.indexOf('-') + 1 : 0;
      position = position.substr(begin);
    }
    let num = Math.floor(Math.random()*(4 - 1) + 1);
    let videoUrl = "/src/assets/alarmVideoMonitor/video/road"+num+".mp4";

    return (
      <div className="precontrol-detail-equip">
        <div className="carHead">
          <div style={{ display: 'flex', alignItems: 'flex-start' }}>
            {this.getIcon(type)}
          </div>
          <div className="precontrol-basic-info">
            <div className="carBasic">
              <span className="equip-name">{equip.equipmentName}</span>
            </div>
            <div className="carInfo">
              <Row className="equip-row">
                <Col span={12}>设备位号:</Col>
                <Col span={12}>
                  {equip.equippositionnum}
                </Col>
              </Row>
              <Row className="equip-row">
                <Col span={12}>所在分区:</Col>
                <Col span={12} >
                  {equip.area}
                </Col>
              </Row>
              <Row className="equip-row">
                <Col span={12}>所在车间:</Col>
                <Col span={12}>
                  {equip.dept }
                </Col>
              </Row>
              <Row className="equip-row">
                <Col span={12}>所在工段：</Col>
                <Col span={12}>
                  {equip.section}
                </Col>
              </Row>
              <Row className="equip-row">
                <Col span={12}>备注：</Col>
                <Col span={12}>
                  {equip.equipmentDesc}
                </Col>
              </Row>
            </div>
          </div>
        </div>
        { type === 'fireEquipment' ?
          <DetailCard title="现场视频" >
            <Video videoUrl={videoUrl} />
          </DetailCard> : ''
        }
      </div>
    );
  }
}

EquipDetail.propTypes = {
  equip: PropTypes.object
};


export default EquipDetail;
