import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col } from 'amos-framework';
import SymIcon from './../../../common/icon/SymIcon';
import DetailCard from './DetailCard';


class ImpEquipDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {},
      impEquip: {}
    };
  }

  componentWillMount() {
    this.setState({ impEquip: this.props.impEquip });
  }

  getDetailComponent = () => {
    const { impEquip = {} } = this.state;
    return (
      <div className="imp-equip-content">
        <DetailCard title="备注" >
          <p>{impEquip.remark}</p>
        </DetailCard>
      </div>
    );
  }

  componentWillReceiveProps(nextProps) {
    this.setState({ impEquip: nextProps.impEquip });
  }

  render() {
    const { impEquip = {} } = this.state;
    return (
      <div className="station">
        <div className="carHead">
          <div style={{ display: 'flex', alignItems: 'flex-start' }}><SymIcon icon="paomojian" style={{ width: '59px', height: '46px' }}></SymIcon></div>
          <div className="precontrol-basic-info">
            <div className="carBasic">
              <span className="carName">{impEquip.name}</span>
            </div>
            <div className="carInfo">
              <Row>
                <Col span={6}>设备编码:</Col>
                <Col span={18}>
                  {impEquip.code}
                </Col>
              </Row>
              <Row>
                <Col span={6}>责任部门:</Col>
                <Col span={18}>
                  {impEquip.depName}
                </Col>
              </Row>
              <Row>
                <Col span={6}>责任人:</Col>
                <Col span={18}>
                  {impEquip.username}
                </Col>
              </Row>
              <Row>
                <Col span={6}>电话:</Col>
                <Col span={18}>
                  {impEquip.tel}
                </Col>
              </Row>
            </div>
          </div>
        </div>
        <div className="carContext">
          {this.getDetailComponent()}
        </div>
      </div>
    );
  }
}

ImpEquipDetail.propTypes = {
  impEquip: PropTypes.object
};

export default ImpEquipDetail;
