import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Tabs, Connect as UIConnect } from 'amos-framework';
import { Connect } from 'amos-3d/lib/designer';
import { eventTopics } from './../../consts';
import CarDetail from './CarDetail';
import AssistDetail from './AssistDetail';
import EquipDetail from './EquipDetail';
import PersonDetail from './PersonDetail';
import EmptyDetail from './EmptyDetail';
import StationDetail from './StationDetail';
import ImpEquipDetail from './ImpEquipDetail';

import imgStatic from './../../../../consts/imgStatic';

import {
  getFireWaterDataAction,
  getpreControlFireStationDetailAction,
  getFireEquipmentAction,
  getFireTruckDetailAction,
  getImpEquipDetail
} from './../../../../services/ledgerService';

const { TabList, Tab, TabPanel } = Tabs;
const { resizeConnect } = Connect;
const eventConnect = UIConnect.eventConnect;
const pointIcon = imgStatic.planDetail;

@resizeConnect
@eventConnect
class PlanDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {},
      assistData: [],
      activeKey: '2',
      type: '',
      display: 'none'
    };
  }

  componentDidMount() {
    console.log('PlanDetail~~~~~~~~~');
    this._bindPubSubEvents();
  }

  onCancal = (e) => {
    this.props.cancal();
  }

  getWaterResource = (id) => {
    getFireWaterDataAction(id).then(data => {
      this.setState({ data });
    });
  }

  getStationResource = (id) => {
    getpreControlFireStationDetailAction(id).then(data => {
      this.setState({ data });
    });
  }

  getFireEquipment = (id) => {
    getFireEquipmentAction(id).then(data => {
      this.setState({ data });
    });
  }

  getFireCar = (id) => {
    getFireEquipmentAction(id).then(data => {
      this.setState({ data });
    });
  }

  getFireTruckDetail = (id) => {
    getFireTruckDetailAction(id).then(data => {
      this.setState({ data });
    });
  }

  getImpEquipment = (id) => {
    getImpEquipDetail(id).then(data => {
      this.setState({ data });
    });
  }

  getDetail = () => {
    const { type, data } = this.state;

    if (!type || !data) {
      return <EmptyDetail />;
    }
    if (type === 'fireFoamRoom' || type === 'fireChamber') {
      return <StationDetail station={data} />;
    } else if (type === 'fireCar') {
      return <CarDetail car={data} />;
    } else if (type === 'hydrant' || type === 'pool') {
      return <StationDetail station={data} />;
    } else if (type === 'fireEquipment') {
      return <EquipDetail equip={data} />;
    } else if (type === 'person') {
      return <PersonDetail />;
    } else if (type === 'video') {
      return <EquipDetail equip={data} type='video' />;
    }  else if (type === 'impEquipment-point') {
      return <ImpEquipDetail equip={data} />;
    } else {
      return <EmptyDetail />;
    }
  }

  _bindPubSubEvents = () => {
    this.props.subscribe(eventTopics.plan_detail, (topic, content) => {
      if (content.type !== 'helpArea') {
        this.setState({ type: content.type, activeKey: '1', display: '' });
      } else {
        this.setState({ display: '' });
      }
      if (content.type === 'fireFoamRoom' || content.type === 'fireChamber') {
        this.getStationResource(content.data.id);
      } else if (content.type === 'fireCar') {
        this.getFireTruckDetail(content.data.id);
      } else if (content.type === 'hydrant' || content.type === 'pool') {
        this.getWaterResource(content.data.id);
      } else if (content.type === 'fireEquipment') {
        this.getFireEquipment(content.data.id);
      }  else if (content.type === 'impEquipment-point') {
        this.getImpEquipment(content.data.id);
      } else if (content.type === 'helpArea') {
        let { assistData } = this.state;
        let { contingencyRo } = content.data;
        if (assistData.length > 0 && parseInt(assistData[0].step || '0') === parseInt(content.data.step || '0')) {
          assistData = [content.data, ...assistData];
        } else if (assistData.length > 0 && parseInt(assistData[0].step || '0') < parseInt(content.data.step || '0')){
          assistData = [content.data];
        } else if (assistData.length <= 0) {
          assistData = [content.data];
        }
        this.setState({ assistData, activeKey: '2', type: 'fireEquipment', data: contingencyRo });
      } else if (content.type === 'video') {
        this.getFireEquipment(content.data.id);
      }
    });
  }

  tabsOnChange = (index, key) => {
    this.setState({ activeKey: key });
  }

  render() {
    const { activeKey, assistData, display } = this.state;

    return (
      <div className="detail" style={{ display }}>
        <Tabs cardMode className="detail-context" activeKey={activeKey} onChange={this.tabsOnChange} >
          <TabList>
            <Tab  activeKey="1">详情</Tab>
            <Tab  activeKey="2" className="zhinengfuzhi">智能辅助</Tab>
          </TabList>
          <TabPanel activeKey="1">{this.getDetail()}</TabPanel>
          <TabPanel activeKey="2"  className="preControl-detail-assist">{assistData.length > 0 ? <AssistDetail data={assistData} /> : <EmptyDetail />}</TabPanel>
        </Tabs>
        <div className="preControl-detail-cancal">
          <a className="detailUp" onClick={this.onCancal.bind(this)}><img className="preControl-detail-cancal-img" src={pointIcon.cancal} alt='' /></a>
        </div>
      </div>
    );
  }
}

PlanDetail.propTypes = {
  subscribe: PropTypes.func,
  cancal: PropTypes.func
};

export default PlanDetail;
