import { commonGet, commonPost, commonPut, formatUrl } from './../utils/request';
import { AisleUrl } from '../consts/urlConsts';

/**
 * 根据城市查询对应通道信息及状态
 * @param {*} city
 */
export const queryAisleDataByCity = (city) => {
  return commonGet(formatUrl(AisleUrl.aisleListUrl, { city }));
};

/**
 * 查询银行经纬度列表
 * @param {*}
 */
export const getBankInfoListData = () => {
  return commonGet(formatUrl(AisleUrl.bankInfoListUrl));
};
