import { SpcSerUrl } from './../consts/urlConsts';
import { commonPost, commonGet, commonDelete } from './../utils/request';

// net 树
export const getWebTreeAction = () => {
  let url = SpcSerUrl.getWebTreeUrl;
  return commonGet(url);
};

// net 树增加树节点
export const addWebTreeAction = (params) => {
  let url = SpcSerUrl.addWebTreeUrl;
  return commonPost(url, params);
};

// net 树删除树节点
export const delWebTreeAction = (id) => {
  let url = `${SpcSerUrl.delWebTreeUrl}/${id}`;
  return commonDelete(url);
};

// net 拓扑图
export const getNetTopoAction = (treeid) => {
  let url = `${SpcSerUrl.getNetTopoUrl}/${treeid}`;
  return commonGet(url);
};

// net 拓扑图更新数据
export const updateNetTopoAction = (params) => {
  let url = SpcSerUrl.updateNetTopoUrl;
  return commonPost(url,params);
};

// net 拓扑图节点详情
export const nodeDetailTopoAction = (id) => {
  let url = `${SpcSerUrl.nodeDetailTopoUrl}/${id}`;
  return commonGet(url);
};
