import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { patrolUrls, secExtUrl } from './../consts/urlConsts';
import { commonGet, commonPost, commonDelete, commonPut } from './../utils/request';

export const queryInputItemAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.inputItemTablesUrl, { page, size }), filter);
};

export const batchDelInputItemAction = (ids) => {
  return commonDelete(formatUrl(patrolUrls.inputItemBatchDelUrl, { ids }));
};

export const saveAsInputItemAction = (ids) => {
  return commonGet(formatUrl(patrolUrls.inputItemSaveAsUrl, { ids }));
};

export const saveInputItemAction = (body) => {
  return commonPost(patrolUrls.inputItemSaveUrl, body);
};

export const queryPlanInfoAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.planInfoTablesUrl, { page, size }), filter);
};

export const queryInputItemDetailAction = (itemID) => {
  return commonGet(formatUrl(patrolUrls.inputItemDetailUrl, { itemID }));
};

/**
 *
 * @param {*巡检计划新增} body
 */
export const createPlanAction = (body) => {
  return commonPost(patrolUrls.planSaveUrl, body);
};

export const queryDeptByOrgCodeAction = () => {
  return commonGet(formatUrl(patrolUrls.deptByOrgCodeUrl, {}));
};

export const queryUserByDeptIdAction = (deptId) => {
  return commonGet(formatUrl(patrolUrls.userInfoByDeptIdUrl, { deptId }));
};

export const queryTaskAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.taskPageUrl, { page, size }), filter);
};

export const batchDelTaskAction = (ids) => {
  return commonDelete(formatUrl(patrolUrls.taskBatchDelUrl, { ids }));
};

export const queryTaskDetailAction = ( id ) => {
  return commonGet(formatUrl(patrolUrls.taskDetailUrl, { id }));
};

export const handleTaskAction = (ids, status) => {
  return commonPut(formatUrl(patrolUrls.taskHandleUrl, { ids , status }));
};

export const saveTaskAction = (body) => {
  return commonPost(patrolUrls.taskAddUrl, body);
};

export const queryDeptUserTree = () => {
  return commonGet(patrolUrls.deptUserTreeUrl);
};

export const feedbackTaskAction = (body) => {
  return commonPost(patrolUrls.taskFeedbackTaskUrl, body);
};

export const queryRouteAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.routePageUrl, { page, size }), filter);
};

export const batchDelRouteAction = (ids) => {
  return commonDelete(formatUrl(patrolUrls.routeBatchDelUrl, { ids }));
};

export const saveRouteAction = (body) => {
  return commonPost(patrolUrls.routeAddUrl, body);
};

export const queryRouteDetailAction = (id) => {
  return commonGet(formatUrl(patrolUrls.routeDetailUrl, { id }));
};

export const updateRouteAction = (body) => {
  return commonPut(patrolUrls.routeUpdateUrl, body);
};

export const queryRoutePointAction = (filter, page, size, id) => {
  return commonPost(formatUrl(patrolUrls.routePointPageUrl, { id, page, size }), filter);
};

export const queryPlanDetByIdAction = (planId) => {
  return commonGet(formatUrl(patrolUrls.planDetByPlanIdUrl, { planId }));
};

export const batchDelRoutePointAction = (routeId, pointIds) => {
  return commonDelete(formatUrl(patrolUrls.routePointBatchDelUrl, { routeId, pointIds }));
};

export const migrateRoutePointAction = (sourceRouteId, pointIds, targetRouteId) => {
  return commonPost(formatUrl(patrolUrls.RoutePointMigrateUrl, { sourceRouteId, pointIds, targetRouteId }));
};

export const queryAllRouteAction = () => {
  return commonGet(patrolUrls.routeUrl);
};

export const queryInputItemByConditionAction = (searchParams) => {
  return commonPost(formatUrl(patrolUrls.inputItemQueryByConditionUrl, {}), searchParams);
};

export const queryInputItemByConditionAction1 = (searchParams) => {
  return commonPost(formatUrl(patrolUrls.inputItemQueryByConditionUrl1, {}), searchParams);
};

export const queryAuthPointAction = (code = '', name = '') => {
  return commonGet(formatUrl(patrolUrls.routePointsAuthUrl, { code, name }));
};


export const addRoutePointAction = (routeId, pointIds) => {
  return commonPost(formatUrl(patrolUrls.routePointAddUrl, { routeId, pointIds }));
};

export const queryPointInputItemAction = (pointId,body) => {
  return commonPost(formatUrl(patrolUrls.pointInputItemUrl, { pointId }),body);
};

export const saveAsPlanAction = (body) => {
  return commonPost(patrolUrls.planSaveAsUrl, body);
};


export const batchDetPlanAction = (body) => {
  return commonPost(patrolUrls.planBatchDetUrl, body);
};

export const queryPlanTaskInfoAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.planTaskTablesUrl, { page, size }), filter);
};

export const reGenPlanTaskAction = (body) => {
  return commonPost(patrolUrls.reGenplanTaskUrl, body);
};

export const deleteplanTaskAction = (body) => {
  return commonPost(patrolUrls.deleteplanTaskUrl, body);
};

export const queryPlanByOrgNoPageAction = (body) => {
  return commonPost(patrolUrls.planInfoNoPageUrl, body);
};

export const printTaskDetailAction = (taskID) => {
  return commonGet(formatUrl(patrolUrls.taskPrintUrl, { taskID }));
};

export const queryCheckInfoAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.checkTablesUrl, { page, size }), filter);
};

export const batchDeCheckAction = (body) => {
  return commonPost(patrolUrls.checkBatchDetUrl, body);
};

export const queryCatalogTreeAction = () => {
  return commonGet(formatUrl(patrolUrls.catalogTreeUrl, {}));
};

export const addCatalogTreeAction = (body) => {
  return commonPost(patrolUrls.catalogTreeSaveUrl, body);
};

export const batDelCatalogTreeAction = (body) => {
  return commonPost(patrolUrls.catalogTreeBatDelUrl, body);
};

export const queryCatalogTreePageAction = (filter, page, size) => {
  return commonPost(formatUrl(patrolUrls.catalogTreeListUrl, { page, size }), filter);
};

export const queryCatalogTreeByIdAction = ( id ) => {
  return commonGet(formatUrl(patrolUrls.catalogTreeDetByIdUrl, { id }));
};


export const forwardTaskAction = ( userId, taskID ) => {
  return commonGet(formatUrl(patrolUrls.forwardTaskUrl, { userId, taskID }));
};


export const queryCheckDetailAction = (checkId) => {
  return commonGet(formatUrl(patrolUrls.checkDetailUrl, { checkId }));
};

export const exportCheckRecordAction = (filter) => {
  return commonPost(formatUrl(patrolUrls.exportCheckRecordUrl), filter);

};

export const seachPermissionAction = () => {
  return commonGet(formatUrl(secExtUrl.opSearchMenusUrl, { nodeName: '', type: window.permissionType }));
};

export const exchangeOrderNumberAction = (src, target) => {
  return commonPut(formatUrl(patrolUrls.exchangeOrderNumberUrl, { src, target }));
};

export const fetchCheckDetailById = (data) => {
  return commonPost(patrolUrls.SpecCheckDetailUrl, data);
};

export const fetchCheckInputById = (data) => {
  return commonPost(patrolUrls.SpecCheckInputById, data);
};

export const fetchShortByCheckIdAndCheckInputId = (checkId, checkInputId,classifyId) => {
  return commonGet(formatUrl(patrolUrls.searchCheckShortUrl, { checkId, checkInputId,classifyId }));
};

export const queryAllItemNoAction = (itemId) => {
  return commonGet(formatUrl(patrolUrls.itemNoQueryUrl, { itemId }));
};

export const startTaskworkFlow = (taskworkIds) => {
  return commonPost(formatUrl(patrolUrls.taskworkStartUrl, { taskworkIds }));
};
