import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { secExtUrl } from './../consts/urlConsts';
import { commonGet, commonPost } from './../utils/request';

export const getCurrentUser = () => {
  return commonGet(secExtUrl.currentUserUrl);
};

export const getSystemAllMenu = () => {
  return commonGet(formatUrl(secExtUrl.systemMenusUrl));
  // return commonGet(formatUrl(secExtUrl.systemMenusUrl, { code, userId }));
};

export const login = (code, userId) => {
  return commonPost(formatUrl(secExtUrl.loginUrl), { code, userId });
};

export const getPermissionsCompany = () => {
  return commonGet(formatUrl(secExtUrl.systemMenusUrl));
};

/**
 * 获取当前角色权限菜单
 * @param {*} roleSeq 角色Id
 */
export const getPermissionsMenus = (roleSeq) => {
  return commonGet(formatUrl(secExtUrl.permissionsMenusUrl, { roleSeq }));
};

// export const getPermissionsMenus = () => {
//   return commonGet(formatUrl(secExtUrl.permissionsMenusUrl));
// };

export const getPermissionsCompanyData = () => {
  return commonGet(formatUrl(secExtUrl.permissionsCompanyUrl));
};

//根据字典编号查询字典列表BANK_ORG
export const getDictionaryList = (dictCode) => {
  return commonGet(formatUrl(secExtUrl.dictionaryValueUrl, { dictCode }));
};


