import { SpcSerUrl, AisleUrl } from './../consts/urlConsts';
import { commonPost, commonGet } from './../utils/request';
import formatUrl from 'amos-processor/lib/utils/urlFormat';

// 树
export const getSelfTopoTreeAction = () => {
  let url = SpcSerUrl.getSelfTopoTreeUrl;
  return commonGet(url);
};

// 拓扑图
export const getSelfTopographyAction = (treeid) => {
  let url = `${SpcSerUrl.getSelfTopographyUrl}/${treeid}`;
  return commonGet(url);
};

//  拓扑图更新数据
export const updateSelfTopographyAction = (params) => {
  let url = SpcSerUrl.updateSelfUrl;
  return commonPost(url,params);
};

// 拓扑图事件列表
export const getTopographyEventsAction = () => {
  let url = SpcSerUrl.getTopographyEventsUrl;
  return commonGet(url);
};

// 拓扑图告警通道
export const getTopoAisleListAction = () => {
  let url = AisleUrl.topoAisleListUrl;
  return commonGet(url);
};


// 查询告警列表
// export const getDeivceListAction = () => {
//   let url = SpcSerUrl.listSelfDevice;
//   return commonGet(url);
// };

export const getDeivceListAction = (page, size,fname) => {
  let url = SpcSerUrl.listSelfDevice;
  return commonGet(formatUrl(url, {fname,page,size }));
};
