import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { FasSerUrl, SpcSerUrl, patrolUrls } from './../consts/urlConsts';
import { commonGet, commonPost } from './../utils/request';

/**
 * 报警信息查询
 */
export const queryAlarmListAction = (filter, page, size) => {
  return commonPost(formatUrl(FasSerUrl.alarmInfoListUrl, { page, size }), filter);
};

/**
 * 查询风险点RPN统计
 */
export const queryRiskSourceRpnCountAction = () => {
  return commonGet(FasSerUrl.riskSourceRpnCountUrl);
};

/**
 * 查询风险点RPN统计
 */
export const queryRiskSourceMatrixAction = () => {
  return commonGet(FasSerUrl.riskSourceMatrixUrl);
};

export const getRiskRiseUprateAction = () => {
  return commonGet(FasSerUrl.riskSourceRiseRateUrl);
};

export const getFireSourceHistoryDataAction = (searchParam, page, size) => {
  let { fireEquipmentName = '', equipmentName = '', startTime = '', endTime = '' } = searchParam;
  let url = formatUrl(FasSerUrl.fireEquipmentHistoryDataUrl, { fireEquipmentName, equipmentName, startTime, endTime, page, size });
  return commonGet(url);
};

//获取厂区下所有区域的rpn值
export const getRegionAreaRpnAction = () => {
  let url = formatUrl(FasSerUrl.getRegionAreaRpnUrl);
  return commonGet(url);
};

//获取固有风险指数数据
export const getInherentIndexDataAction = () => {
  let url = formatUrl(SpcSerUrl.getInherentIndexDataUrl);
  return commonGet(url);
};

//获取隐患治理逾期统计数据
export const getOverdueDangerDataAction = () => {
  let url = formatUrl(SpcSerUrl.getOverdueDangerDataUrl);
  return commonGet(url);
};

//获取风险按部门统计数据
export const getRiskDataByDeptAction = () => {
  let url = formatUrl(SpcSerUrl.getRiskDataByDeptUrl);
  return commonGet(url);
};

//获取隐患按部门统计数据
export const getDangerDataByDeptAction = () => {
  let url = formatUrl(SpcSerUrl.getDangerDataByDeptUrl);
  return commonGet(url);
};

//获取告警信息数据
export const getWarningsData = () => {
  let url = formatUrl(patrolUrls.getWarningsDataUrl);
  return commonGet(url);
};

// 查询告警信息分页
export const getWarningsByPageData = (data,page, size) => {
  let url = patrolUrls.getWarningsByPageData;
  return commonPost(formatUrl(url, { page, size }), data);
};

// 告警信息导出excel
export const getWarningsExcelData = (data) => {
  let url = patrolUrls.exportWarningsExcelUrl;
  return url;
};
