import React from 'react';
import PropTypes from 'prop-types';

const Value = props => {
  const { datas } = props;
  return (
    <div className="common-values">
      {
        datas.map(d => {
          return (
            <p key={d.key} className="values-item">
              <span className="item-label">{d.label}:</span>
              <span className="item-text">{d.text || d.value}</span>
            </p>
          );
        })
      }
    </div>
  );
};

Value.propTypes = {
  datas: PropTypes.arrayOf(PropTypes.shape({
    key: PropTypes.string,
    label: PropTypes.string,
    text: PropTypes.string,
    value: PropTypes.string
  }))
};

export default Value;
