import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { trim } from 'amos-tool';
import { Select, Input } from 'amos-framework';
import { SingleQueryEnum } from 'amos-processor/lib/config/queryEnum';
import {
  monitorRegionListAction
} from 'SERVICES/3dService';

const Option = Select.Option;
/**
 * 检索-过滤栏
 *
 * @class Filter
 * @extends {Component}
 */
class Filter extends Component {

  static propTypes = {
    onFilterChange: PropTypes.func
  };

  constructor(props) {
    super(props);
    this.state = {
      regionList: []
    };
  }

  componentDidMount() {
    monitorRegionListAction().then(d => this.setState({ regionList: d || [] }));
  }

  render() {
    const { onFilterChange } = this.props;
    const { regionList } = this.state;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={regionList}
          renderOption={item => <Option className="datapane-select-option" value={item.id}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">区域</Option>}
          onChange={(e) => onFilterChange('category', e, SingleQueryEnum.EQUAL)}
        />
        <Input
          className="datapane-filter-item datapane-filter-input"
          placeholder="编号"
          onBlur={(e) => onFilterChange('code', trim(e.target.value), SingleQueryEnum.LIKE)}
        />
      </div>
    );
  }
}

export default Filter;
