import React from 'react';
import {
  recordAction,
  recordStatusListAction
} from 'SERVICES/3dService';
import Icon from 'amos-icon';
import DataPaneBasic from './../common/DataPaneBasic';
import DataPaneContent from './../common/DataPaneContent';
import Filter from './Filter';
import PaneItem from './../common/PaneItem';
import ListPaginate from './../common/ListPaginate';

/**
 * 记录
 * @class Record
 * @extends {DataPaneBasic}
 */
class Record extends DataPaneBasic {
  constructor(props) {
    super(props);
    this.state = {
      searchName: 'pointName',
      data: [],
      filter: [],
      statusList: [],
      page: 0,
      pageSize: 10
    };
  }

  componentDidMount(){
    this.onSearch();
    recordStatusListAction().then(d => this.setState({ statusList: d || [] }));
  }
  /**
   * 点击记录中的一个
   */
  onClick = (item) => {

  }


  onSearch = (page) => {
    const { filter, pageSize } = this.state;
    recordAction(filter, page || 0, pageSize).then(d => {
      this.list.setData(d, this);
    });
  }

  renderItem = (item) => {
    const status = this.state.statusList.find(e => e.code === item.isOk) || {};
    return [
      { name: '巡检点', value: 'pointName' },
      { name: '时间', value: 'checkTime' },
      { name: '状态', value: 'status', render: () => (
        <span className="datapane-prop-value" style={{ color: status.color }}>
          {status.name}&nbsp;{ status.color && <Icon icon="warning" style={{ color: status.color }} /> }
        </span>
      ) }
    ];
  }

  render() {
    const { searchName, data, statusList, pageSize } = this.state;
    return (
      <DataPaneContent
        onFilterChange={this.onFilterChange}
        statusList={statusList}
        filter={Filter}
        searchName={searchName}
      >
        <ListPaginate
          ref={node => this.list = node}
          data={data}
          pageSize={pageSize}
          onChangePage={this.onSearch}
          renderItem={e => <PaneItem renderItem={this.renderItem} key={e.checkID} data={e} onClick={this.onClick} />}
        />
      </DataPaneContent>
    );
  }
}

export default Record;
